% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gipp.R
\name{read_gipp}
\alias{read_gipp}
\alias{set_gipp}
\title{Manage GIPP parameters for Sen2Cor}
\usage{
read_gipp(gipp_names, gipp_path = NA)

set_gipp(gipp = list(), gipp_path = NA, use_dem = NA)
}
\arguments{
\item{gipp_names}{Character vector with the names of the parameters
to be read.}

\item{gipp_path}{Character path of the GIPP XML file to be read
(\code{\link[=read_gipp]{read_gipp()}}) or written (\code{\link[=set_gipp]{set_gipp()}}).
In \code{\link[=read_gipp]{read_gipp()}}, if NA (default), the default sen2r GIPP path is read;
in \code{\link[=set_gipp]{set_gipp()}}, setting this argument is mandatory (see details).}

\item{gipp}{(optional) Ground Image Processing Parameters (GIPP)
(see \code{\link[=sen2cor]{sen2cor()}} for further details).
Elements whose name is missing in the XML file are skipped.}

\item{use_dem}{Logical, determining if a DEM should be set for being used
for topographic correction in the XML specified with argument \code{gipp_path}
(see \code{\link[=sen2cor]{sen2cor()}} for further details).}
}
\value{
\code{\link[=read_gipp]{read_gipp()}} returns a named list of GIPP with the required parameters
(values not found in the XML are skipped).

\code{\link[=set_gipp]{set_gipp()}} returns NULL (the function is called for its side effects).
}
\description{
\code{\link[=read_gipp]{read_gipp()}} reads Ground Image Processing Parameters (GIPP)
from the default sen2r GIPP path or from an XML file.

\code{\link[=set_gipp]{set_gipp()}} modifies values of a list of GIPP in an XML file
(or creates a new XML file with the desired GIPP).
}
\details{
In \code{\link[=set_gipp]{set_gipp()}}, editing /resetting
the default sen2r GIPP XML file was disabled to grant code reproducibility
among different machines (an error is returned if \code{gipp_path} is not set).
Users who want to do that (being aware of the risk doing that)
must explicitly define the argument \code{gipp_path}
as the path of the default GIPP file, which is
\code{file.path(dirname(attr(load_binpaths(), "path")), "sen2r_L2A_GIPP.xml")}.
}
\note{
License: GPL 3.0
}
\examples{
\donttest{
# Read default values
read_gipp(c("dem_directory", "dem_reference"))
# Set the use of a topographic correction
set_gipp(use_dem = TRUE, gipp_path = gipp_temp <- tempfile())
# Read the parameters in the created temporary files
read_gipp(c("DEM_Directory", "DEM_Reference"), gipp_path = gipp_temp)
# Set not to use a topographic correction
set_gipp(use_dem = FALSE, gipp_path = gipp_temp <- tempfile())
# This is equivalent to:
# set_gipp(
#   list(DEM_Directory = NA, DEM_Reference = NA), 
#   gipp_path = gipp_temp <- tempfile()
# )
# Read again the parameters in the created temporary files
read_gipp(c("DEM_Directory", "DEM_Reference"), gipp_path = gipp_temp)
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473. DOI:
\href{https://doi.org/10.1016/j.cageo.2020.104473}{10.1016/j.cageo.2020.104473},
URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
