% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_tiles.R
\name{s2_tiles}
\alias{s2_tiles}
\title{Load Sentinel-2 tiles}
\usage{
s2_tiles()
}
\value{
An sf spatial object containing the extent of the tiles.
}
\description{
Load the vector object of the Sentinel-2 tiles.
When the function is run for the first time, it downloads the vector file
from the sen2r GitHub repository and it saves it on disk.
}
\note{
License: GPL 3.0
}
\examples{
# Retrieve all the tiles
s2tiles <- s2_tiles()

# Extract a subset of all the tiles
httr::GET(
  "https://raw.githubusercontent.com/ranghetti/sen2r/devel/utils/vector/ch_bound.rds", 
  httr::write_disk(ch_path <- tempfile())
)
ch <- readRDS(ch_path)
s2tiles_ch <- s2tiles[suppressMessages(sf::st_intersects(ch, s2tiles))[[1]],]
s2_coords <- sf::st_coordinates(suppressWarnings(sf::st_centroid(s2tiles_ch)))

# Show the tiles
plot(s2tiles_ch$geometry, border = "blue")
plot(ch, border = "red", add = TRUE)
text(s2_coords[,1], s2_coords[,2], s2tiles_ch$tile_id, col = "blue", cex = .75)

# Use function tiles_intersects() to exclude unuseful tiles.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
