% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_element.R
\name{find_element}
\alias{find_element}
\alias{find_element.selenider_session}
\alias{find_element.selenider_element}
\title{Find a single HTML child element}
\usage{
find_element(x, ...)

\method{find_element}{selenider_session}(
  x,
  css = NULL,
  xpath = NULL,
  id = NULL,
  class_name = NULL,
  name = NULL,
  link_text = NULL,
  ...
)

\method{find_element}{selenider_element}(
  x,
  css = NULL,
  xpath = NULL,
  id = NULL,
  class_name = NULL,
  name = NULL,
  link_text = NULL,
  ...
)
}
\arguments{
\item{x}{A selenider session or element.}

\item{...}{Arguments passed to methods.}

\item{css}{A css selector.}

\item{xpath}{An XPath.}

\item{id}{The id of the element you want to select.}

\item{class_name}{The class name of the element you want to select.}

\item{name}{The name attribute of the element you want to select.}

\item{link_text}{The link text of the link element that you would like to
select.}
}
\value{
A \code{selenider_element} object.
}
\description{
Find the first HTML element using a CSS selector, an XPath, or a variety
of other methods.
}
\details{
If more than one method is used to select an element (e.g. \code{css} and
\code{xpath}), the first element which satisfies all conditions will be found.

CSS selectors are generally recommended over other options, since they are usually
the easiest to read. Use \code{"tag_name"} to select by tag name, \code{".class"} to select
by class, and \code{"#id"} to select by id.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div class='class1'>
  <div id='id1'>
    <a href='https://r-project.org'>Click me!</a>
  </div>
  <p>Example text</p>
</div>
"

session <- minimal_selenider_session(html)

session |>
  find_element("div")

session |>
  find_element(name = "div") |>
  find_element(xpath = "./p")

s("div") |>
  find_element("#id1")

s("div") |>
  find_element(id = "id1") |>
  find_element(link_text = "Click me!")

# Complex Xpath expressions are easier to read as chained CSS selectors.
s("//div[contains(@class, 'class1')]/div/a")

s("div.class1") |>
  find_element("div") |>
  find_element("a")

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=s]{s()}} to quickly select an element without specifying the session.
\item \code{\link[=find_elements]{find_elements()}} to select multiple elements.
\item \code{\link[=selenider_session]{selenider_session()}} to begin a session.
}
}
