% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/funs.groupfs.R
\name{groupfsInf}
\alias{groupfsInf}
\title{Compute selective p-values for a model fitted by \code{groupfs}.}
\usage{
groupfsInf(obj, sigma = NULL, projs = NULL, verbose = FALSE)
}
\arguments{
\item{obj}{Object returned by \code{\link{groupfs}} function}

\item{sigma}{Estimate of error standard deviation. If NULL (default), this is estimated using the mean squared residual of the full least squares fit when n >= 2p, and the mean squared residual of the selected model when n < 2p. In the latter case, the user should use \code{\link{estimateSigma}} function for a more accurate estimate.}

\item{projs}{Additional projections to define model selection event. For use with cross-validation. Default is NULL and it is not recommended to change this.}

\item{verbose}{Print out progress along the way? Default is FALSE.}
}
\value{
An object of class "groupfsInf" containing selective p-values for the fitted model \code{obj}. The default printing behavior should supply adequate information.

\describe{
  \item{vars}{Labels of the active groups in the order they were included.}
  \item{pv}{Selective p-values computed from appropriate truncated distributions.}
  \item{sigma}{Estimate of error variance used in computing p-values.}
  \item{TC}{Observed value of truncated chi.}
  \item{df}{Rank of group of variables when it was added to the model.}
  \item{support}{List of intervals defining the truncation region of the truncated chi.}
}
}
\description{
Computes p-values for each group of variables in a model fitted by \code{\link{groupfs}}. These p-values adjust for selection by truncating the usual \code{chi^2} statistics to the regions implied by the model selection event. Details are provided in a forthcoming work.
}
\examples{
#NOT RUN
#set.seed(1)
#n <- 40
#p <- 20
#index <- sort(rep(1:(p/2), 2))
#steps <- 10
#sparsity <- 5
#snr <- 3
#   x <- matrix(rnorm(n*p), nrow=n)
#      beta <- rep(0, p)
#      beta[which(index %in% 1:sparsity)] <- snr
#      y <-  x %*% beta+rnorm(n)

#fit <- groupfs(x, y, index=1:p, maxsteps = steps)

#out<- groupfsInf(fit)
}

