% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selacSim.R
\name{NucSimulator}
\alias{NucSimulator}
\title{Simulate DNA under General-Time Reversible model}
\usage{
NucSimulator(phy, pars, nsites, nuc.model, base.freqs,
  include.gamma = TRUE, gamma.type = "median", ncats = 4,
  start.vals_array = NULL, user.rate.cats = NULL, user.rates = NULL)
}
\arguments{
\item{phy}{The phylogenetic tree with branch lengths.}

\item{pars}{A vector of parameters used for the simulation. They are ordered as follows: gamma shape and the rates for the nucleotide model.}

\item{nsites}{The number of sites to simulate.}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{base.freqs}{The base frequencies for A C G T (in that order).}

\item{include.gamma}{Boolean on whether to use a gamma model}

\item{gamma.type}{How the gamma bins are used}

\item{ncats}{The number of discrete gamma categories.}

\item{start.vals_array}{A vector of nucleotides to be used as the starting nucleotide for each site in the simulation.}

\item{user.rate.cats}{The user supplied gamma categories to use instead of choosing at random.}

\item{user.rates}{The user supplied rates to use instead of choosing categories at random.}
}
\description{
Simulates nucleotide data based on parameters under the GTR+G model
}
\details{
Simulates a nucleotide matrix using parameters under the GTR+G model. Note that the output can be written to a fasta file using the write.dna() function in the \code{ape} package.
}
