% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selon.R
\name{SelonOptimize}
\alias{SelonOptimize}
\title{Optimize parameters under the SELON model}
\usage{
SelonOptimize(nuc.data.path, n.partitions = NULL, phy,
  edge.length = "optimize", edge.linked = TRUE,
  optimal.nuc = "majrule", nuc.model = "GTR",
  global.nucleotide.model = TRUE, diploid = TRUE, verbose = FALSE,
  n.cores = 1, max.tol = .Machine$double.eps^0.25, max.evals = 1e+06,
  cycle.stage = 12, max.restarts = 3, output.by.restart = TRUE,
  output.restart.filename = "restartResult", fasta.rows.to.keep = NULL)
}
\arguments{
\item{nuc.data.path}{Provides the path to the directory containing the gene specific fasta files that contains the nucleotide data.}

\item{n.partitions}{The number of partitions to analyze. The order is based on the Unix order of the fasta files in the directory.}

\item{phy}{The phylogenetic tree to optimize the model parameters.}

\item{edge.length}{Indicates whether or not edge lengths should be optimized. By default it is set to "optimize", other option is "fixed", which user-supplied branch lengths.}

\item{edge.linked}{A logical indicating whether or not edge lengths should be optimized separately for each gene. By default, a single set of each lengths is optimized for all genes.}

\item{optimal.nuc}{Indicates what type of optimal.nuc should be used. At the moment there is only a single option: "majrule".}

\item{nuc.model}{Indicates what type nucleotide model to use. There are three options: "JC", "GTR", or "UNREST".}

\item{global.nucleotide.model}{assumes nucleotide model is shared among all partitions}

\item{diploid}{A logical indicating whether or not the organism is diploid or not.}

\item{verbose}{Logical indicating whether each iteration be printed to the screen.}

\item{n.cores}{The number of cores to run the analyses over.}

\item{max.tol}{Supplies the relative optimization tolerance.}

\item{max.evals}{Supplies the max number of iterations tried during optimization.}

\item{cycle.stage}{Specifies the number of cycles per restart. Default is 12.}

\item{max.restarts}{Supplies the number of random restarts.}

\item{output.by.restart}{Logical indicating whether or not each restart is saved to a file. Default is TRUE.}

\item{output.restart.filename}{Designates the file name for each random restart.}

\item{fasta.rows.to.keep}{Indicates which rows to remove in the input fasta files.}
}
\description{
Optimizes model parameters under the SELON model
}
\details{
SELON stands for SELection On Nucleotides. This function takes a user supplied topology and a set of fasta formatted sequences and optimizes the parameters in the SELON model. Selection is based on selection towards an optimal nucleotide at each site, which is based simply on the majority rule of the observed data. The strength of selection is then varied along sites based on a Taylor series, which scales the substitution rates. Still a work in development, but so far, seems very promising.
}
\examples{
\donttest{
system(paste("mkdir", "uceSet", sep=" "))
sim.dat <- SelonSimulator(phy=phy, pars=model.fit$pars.sims[1,], 
	nuc.optim_array=model.fit$optimal.nuc.list[[1]], nuc.model=model.fit$nuc.model, 
	diploid=TRUE)
write.dna(sim.dat, file=paste("uceSet", "/gene",  "TEST", ".fasta", sep=""), 
	format="fasta", colw=1000000)
pp <- SelonOptimize(nuc.data.path="uceSet/", phy=phy, nuc.model="GTR", n.cores=3)
}
}
