% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_likelihood.R
\name{calculate_likelihood}
\alias{calculate_likelihood}
\title{Calculate a dataset's likelihood using change points of \code{segmentr} object}
\usage{
calculate_likelihood(results, newdata, likelihood)
}
\arguments{
\item{results}{a segmentr object, which contains the definition of the change points to be applied}

\item{newdata}{a dataset for which we wish to calculate the total likelihood}

\item{likelihood}{a likelihood function to be used to calculate the likelihood of each segment}
}
\description{
Given the change points in a segmentr object, this function splits a
new dataset into segments and then calculates the total likelihood
using the likelihood function of the \code{segmentr} object.
}
\details{
This function splits a \code{newdata} dataset into segments according to the
change points in the \code{results} segmentr object. It then uses the \code{likelihood}
function of the segmentr object to calculate the total likelihood of the new object.
}
