% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation}
\alias{segmentation}
\alias{segmentation.data.frame}
\alias{segmentation.Move}
\alias{segmentation.ltraj}
\alias{segmentation_internal}
\title{Segmentation of movement data - Generic function}
\usage{
segmentation(x, ...)

\method{segmentation}{data.frame}(x, ...)

\method{segmentation}{Move}(x, ...)

\method{segmentation}{ltraj}(x, ...)

segmentation_internal(
  x,
  seg.var,
  diag.var,
  order.var,
  lmin,
  Kmax,
  scale.variable,
  sameSigma = FALSE,
  ...
)
}
\arguments{
\item{x}{data.frame with observations}

\item{...}{additional parameters given to \link{chooseseg_lavielle}}

\item{seg.var}{names of the variables used for
segmentation (either one or two names).}

\item{diag.var}{names of the variables on which
statistics are calculated.}

\item{order.var}{names of the variable with which states are ordered.}

\item{lmin}{minimum length of segments.}

\item{Kmax}{maximum number of segments.}

\item{scale.variable}{TRUE or FALSE for automatic scaling of variables
(reduction and  centering)}

\item{sameSigma}{does segments have same variance ?}
}
\value{
a \code{\link{segmentation-class}} object
}
\description{
Segmentation of movement data. No clustering. Method available for
data.frame,  move and ltraj object. The algorithm finds for each number of
segment the optimal segmentation using a Dynamic Programming approach. The
number of segment is then chosen using Lavielle's (2005) procedure based on
locating rupture in the penalized likelihood.
}
\examples{
df <-  test_data()$data
#' # data is a data.frame with column 'x' and 'y'
# Simple segmentation with automatic subsampling
# if data has more than 1000 rows:
res <- segmentation(df, Kmax = 30, lmin = 10, seg.var = c("x","y"))
 # Plot results
 plot(res)
 segmap(res)
 # check likelihood of alternative number of segment possible. There should
 # be a clear break if the segmentation is good
 plot_likelihood(res)
\dontrun{
# Advanced options:
# Run with automatic subsampling if df has more than 500 rows:
res <- segmentation(df, Kmax = 30, lmin = 10,
 seg.var = c("x","y"),  subsample_over = 500)

# Run with subsampling by 2:
res <- segmentation(df, Kmax = 30, lmin = 10, 
seg.var = c("x","y"), subsample_by = 2)
 
# Disable subsampling:
res <- segmentation(df, Kmax = 30, lmin = 10,
 seg.var = c("x","y"), subsample = FALSE)

# Run on other kind of variables : 
 res <- segmentation(df, Kmax = 30, lmin = 10, seg.var = c("dist","angle"))
 
# Automatic scaling of variables for segmentation 
(set a mean of 0 and a standard deviation of 1 for both variables)

 res <- segmentation(df, Kmax = 30, lmin = 10, 
 seg.var = c("dist","angle"), scale.variable = TRUE)
 
}
}
