% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_plot.R, R/plot.compare_performance.R
\name{data_plot}
\alias{data_plot}
\alias{data_plot.compare_performance}
\title{Prepare objects for plotting or plot objects}
\usage{
data_plot(x, ...)

\method{data_plot}{compare_performance}(x, data = NULL, ...)
}
\arguments{
\item{x}{An object.}

\item{...}{Arguments passed to or from other methods.}

\item{data}{The original data used to create this object. Can be a
statistical model.}
}
\description{
\code{data_plot()} extracts and transforms an object for plotting,
while \code{plot()} visualizes results of functions from different packages in
\href{https://github.com/easystats}{easystats-project}. See the documentation
for your object's class:
\itemize{
\item \link[=plot.see_bayesfactor_models]{bayestestR::bayesfactor_models()}
\item \link[=plot.see_bayesfactor_parameters]{bayestestR::bayesfactor_parameters()}
\item \link[=plot.see_equivalence_test]{bayestestR::equivalence_test()}
\item \link[=plot.see_estimate_density]{bayestestR::estimate_density()}
\item \link[=plot.see_hdi]{bayestestR::hdi()}
\item \link[=plot.see_p_direction]{bayestestR::p_direction()}
\item \link[=plot.see_p_significance]{bayestestR::p_significance()}
\item \link[=plot.see_si]{bayestestR::si()}
\item \link[=plot.see_effectsize_table]{effectsize::effectsize()}
\item \link[=plot.see_estimate_contrasts]{modelbased::estimate_contrasts()}
\item \link[=plot.see_compare_parameters]{parameters::compare_parameters()}
\item \link[=plot.see_parameters_distribution]{parameters::describe_distribution()}
\item \link[=plot.see_parameters_model]{parameters::model_parameters()}
\item \link[=plot.see_parameters_pca]{parameters::principal_components()}
\item \link[=plot.see_n_factors]{parameters::n_clusters()}
\item \link[=plot.see_n_factors]{parameters::n_factors()}
\item \link[=plot.see_parameters_simulate]{parameters::simulate_parameters()}
\item \link[=plot.see_check_collinearity]{performance::check_collinearity()}
\item \link[=plot.see_check_heteroscedasticity]{performance::check_heteroscedasticity()}
\item \link[=plot.see_check_homogeneity]{performance::check_homogeneity()}
\item \link[=plot.see_check_normality]{performance::check_normality()}
\item \link[=plot.see_check_outliers]{performance::check_outliers()}
\item \link[=plot.see_compare_performance]{performance::compare_performance()}
\item \link[=plot.see_performance_roc]{performance::performance_roc()}
\item \link[=plot.see_performance_pp_check]{performance::check_posterior_predictions()}
}
}
\details{
\code{data_plot()} is in most situation not needed when the purpose
is plotting, since most \code{plot()}-functions in \pkg{see} internally call
\code{data_plot()} to prepare the data for plotting.
\cr \cr
Many \code{plot()}-functions have a \code{data}-argument that is needed when
the data or model for plotting can't be retrieved via \code{data_plot()}. In
such cases, \code{plot()} gives an error and asks for providing data or models.
\cr \cr
Most \code{plot()}-functions work out-of-the-box, i.e. you don't need to do much
more than calling \verb{plot(<object>)} (see 'Examples'). Some plot-functions
allow to specify arguments to modify the transparency or color of geoms,
these are shown in the 'Usage' section.
}
\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true") && require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(bayestestR)
library(rstanarm)

model <<- suppressWarnings(stan_glm(
  Sepal.Length ~ Petal.Width * Species,
  data = iris,
  chains = 2, iter = 200, refresh = 0
))

x <- rope(model, verbose = FALSE)
plot(x)

x <- hdi(model)
plot(x) + theme_modern()

x <- p_direction(model, verbose = FALSE)
plot(x)

model <<- suppressWarnings(stan_glm(
  mpg ~ wt + gear + cyl + disp,
  chains = 2,
  iter = 200,
  refresh = 0,
  data = mtcars
))
x <- equivalence_test(model, verbose = FALSE)
plot(x)
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://easystats.github.io/see/articles/}{Package-Vignettes}
}
