% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_simulate.R
\name{plot.see_parameters_simulate}
\alias{plot.see_parameters_simulate}
\title{Plot method for simulated model parameters}
\usage{
\method{plot}{see_parameters_simulate}(
  x,
  data = NULL,
  stack = TRUE,
  show_intercept = FALSE,
  n_columns = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{data}{The original data used to create this object. Can be a
statistical model or such.}

\item{stack}{Logical, if \code{TRUE}, densities are plotted as stacked lines.
Else, densities are plotted for each parameter among each other.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{n_columns}{For models with multiple components (like fixed and random, count and zero-inflated), defines the number of columns for the panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::simulate_parameters()} function.
}
\examples{
library(parameters)
m <- lm(mpg ~ wt + cyl + gear, data = mtcars)
result <- simulate_parameters(m)
result
plot(result)
}
