% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.parameters_model.R,
%   R/plot.parameters_sem.R
\name{plot.see_parameters_model}
\alias{plot.see_parameters_model}
\alias{plot.see_parameters_sem}
\title{Plot method for model parameters}
\usage{
\method{plot}{see_parameters_model}(
  x,
  show_intercept = FALSE,
  point_size = 0.8,
  sort = NULL,
  n_columns = NULL,
  ...
)

\method{plot}{see_parameters_sem}(
  x,
  data = NULL,
  type = c("regression", "correlation", "loading"),
  threshold_coefficient = NULL,
  threshold_p = NULL,
  ci = TRUE,
  size = 22,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the intercept-parameter
has a posterior distribution on a very different location, so density curves of
posterior distributions for other parameters are hardly visible.}

\item{point_size}{Size of point-geoms.}

\item{sort}{\describe{
  \item{Plotting model parameters}{
  If \code{NULL}, coefficients are plotted in the order as they appear in the summary. Use \code{sort = "ascending"} (or \code{sort = TRUE})) resp. \code{sort = "descending"} to sort coefficients in ascending or descending order.
  }
  \item{Plotting Bayes factors}{
  Sort pie-slices by posterior probability (descending)?
  }
}}

\item{n_columns}{For models with multiple components (like fixed and random, count and zero-inflated), defines the number of columns for the panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{...}{Arguments passed to or from other methods.}

\item{data}{The original data used to create this object. Can be a
statistical model or such.}

\item{type}{Character vector, indicating the type of plot.}

\item{threshold_coefficient}{Numeric, threshold at which value coefficients will be displayed.}

\item{threshold_p}{Numeric, threshold at which value p-values will be displayed.}

\item{ci}{Logical, whether confidence intervals should be added to the plot.#'}

\item{size}{Size of geoms. Depends on the context of the \code{plot()} function,
so this argument may change size of points, lines or bars.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::model_parameters()} function.
}
\examples{
library(parameters)
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
result <- model_parameters(m)
result
plot(result)
}
