% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_color_social.R
\name{scale_color_social}
\alias{scale_color_social}
\alias{scale_color_social_d}
\alias{scale_color_social_c}
\alias{scale_colour_social}
\alias{scale_colour_social_c}
\alias{scale_colour_social_d}
\alias{scale_fill_social}
\alias{scale_fill_social_d}
\alias{scale_fill_social_c}
\title{Social color palette}
\usage{
scale_color_social(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_color_social_d(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_color_social_c(
  palette = "complement",
  discrete = FALSE,
  reverse = FALSE,
  ...
)

scale_colour_social(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_colour_social_c(
  palette = "complement",
  discrete = FALSE,
  reverse = FALSE,
  ...
)

scale_colour_social_d(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_fill_social(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_fill_social_d(
  palette = "complement",
  discrete = TRUE,
  reverse = FALSE,
  ...
)

scale_fill_social_c(
  palette = "complement",
  discrete = FALSE,
  reverse = FALSE,
  ...
)
}
\arguments{
\item{palette}{Character name of palette. Can be "full", "ice", "rainbow", "complement", or "contrast".}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.}

\item{reverse}{Boolean indicating whether the palette should be reversed.}

\item{...}{Additional arguments to pass to \code{\link[=colorRampPalette]{colorRampPalette()}}.}
}
\description{
The palette based on Social (https://www.materialui.co/socialcolors).
Use \code{scale_color_social_d} for \emph{discrete} categories and
\code{scale_color_social_c} for a \emph{continuous} scale.
}
\examples{
library(ggplot2)
library(see)

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_boxplot() +
  theme_modern() +
  scale_fill_social_d()

ggplot(iris, aes(x = Species, y = Sepal.Length, fill = Species)) +
  geom_violin() +
  theme_modern() +
  scale_fill_social_d(palette = "ice")

ggplot(iris, aes(x = Petal.Length, y = Petal.Width, color = Sepal.Length)) +
  geom_point() +
  theme_modern() +
  scale_color_social_c(palette = "rainbow")

}
