% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_secuTrial.R
\name{diff_secuTrial}
\alias{diff_secuTrial}
\title{Returns differences in the setup of two \code{secuTrialdata} objects}
\usage{
diff_secuTrial(x, y)
}
\arguments{
\item{x}{a \code{secuTrialdata} object (the older export)}

\item{y}{a \code{secuTrialdata} object (the newer export)}
}
\value{
If there are differences, \code{diff_secuTrial()} will produce a list of vectors.
        The fist vector informs about new forms and the second vector informs about
        new variables.
}
\description{
During ongoing studies it is possible that changes to the DataCapture interface
             are made. Sometimes these changes may call for adjustments in analysis code.
             It is considered good practice to run \code{diff_secuTrial()} on the last export
             and the current export of a project to at least make yourself aware of
             potential changes to the setup. If there are differences, the results of this function should
             be interpreted as a first indicator since they may not cover all alterations.
             Information is returned on new forms and variables.
             A detailed list of changes can be produced in the FormBuilder with
             "Compare project setup".
}
\examples{
# read exports

# v1 is essentially a clone of the CTU05 setup
ctu06_v1 <- read_secuTrial(system.file("extdata", "sT_exports", "change_tracking",
                                       "s_export_CSV-xls_CTU06_version1.zip",
                                       package = "secuTrialR"))
# v2 contains 2 additional forms (mnpctu06anewform, mnpctu06anothernewform) and
# 2 additional variables (new_item_in_fu, new_item_in_new_form)
ctu06_v2 <- read_secuTrial(system.file("extdata", "sT_exports", "change_tracking",
                                       "s_export_CSV-xls_CTU06_version2.zip",
                                       package = "secuTrialR"))
# return diff
diff_secuTrial(ctu06_v1, ctu06_v2)

}
