% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CryptoRSIheatmap.R
\name{CryptoRSIheatmap}
\alias{CryptoRSIheatmap}
\title{CryptoRSI Heatmap Function}
\usage{
CryptoRSIheatmap(
  coin_num = 200,
  useRank = 1000,
  n = 21,
  useRankPlot = TRUE,
  OutputData = FALSE
)
}
\arguments{
\item{coin_num}{An integer specifying the number of coins to display in the heatmap.}

\item{useRank}{An integer defining the range within which coins are randomly
selected based on their market cap ranking.}

\item{n}{An integer indicating the number of periods for calculating moving
averages in the RSI computation.}

\item{useRankPlot}{A boolean that determines if the x-axis should plot ranks
instead of sequential numbers.}

\item{OutputData}{A boolean that decides if the function should return the final
plot data table.}
}
\value{
If `OutputData` is TRUE, returns a data frame with symbols,
 ranks (or sequential numbers), RSI values, and colors for plotting.
 Otherwise, displays a heatmap plot.
}
\description{
This function provides a heatmap visualization of RSI values for
 a specified number of cryptocurrencies. Selected randomly based on their market
 cap ranking, it aims to offer insights into the current market sentiment.
}
\details{
CryptoRSI Heatmap

Generates a heatmap of the Relative Strength Index (RSI) for a randomly selected
subset of cryptocurrencies. This function leverages the `crypto2` and `TTR`
packages to fetch cryptocurrency data and calculate RSI values, respectively.
The heatmap visualizes RSI values to identify potential overbought or oversold
conditions in the crypto market.
}
\examples{
\dontrun{
CryptoRSIheatmap(coin_num = 200, useRank = 1000, n = 21,
        useRankPlot = TRUE, OutputData = FALSE)
}

}
\author{
Satoshi Kume
}
