% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd_df.R
\name{tbl_sum.cnd_df}
\alias{tbl_sum.cnd_df}
\title{Conditioned tibble header print method}
\usage{
\method{tbl_sum}{cnd_df}(x, ...)
}
\arguments{
\item{x}{A conditioned tibble of class \code{cnd_df}.}

\item{...}{Additional arguments passed to the default print method.}
}
\value{
A character vector with header values of the conditioned data frame.
}
\description{
Conditioned tibble header print method. This S3 method adds an extra line
in the header of a tibble that indicates the tibble is a conditioned tibble
(\verb{# Cond. tbl:}) followed by the tally of the conditioning vector: number
of TRUE, FALSE and NA values: e.g., \code{1/1/1}.
}
\examples{
df <- data.frame(x = c(1L, NA_integer_, 3L))
(cnd_df <- condition_add(dat = df, x >= 2L))
pillar::tbl_sum(cnd_df)

}
\seealso{
\code{\link[=ctl_new_rowid_pillar.cnd_df]{ctl_new_rowid_pillar.cnd_df()}}.
}
