% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R
\name{Families}
\alias{Families}
\alias{Beta}
\alias{lognormal}
\alias{gamma_mix}
\alias{lognormal_mix}
\alias{nbinom2_mix}
\alias{nbinom2}
\alias{nbinom1}
\alias{truncated_nbinom2}
\alias{truncated_nbinom1}
\alias{student}
\alias{tweedie}
\alias{censored_poisson}
\alias{delta_gamma}
\alias{delta_gamma_mix}
\alias{delta_lognormal}
\alias{delta_lognormal_mix}
\alias{delta_truncated_nbinom2}
\alias{delta_truncated_nbinom1}
\alias{delta_poisson_link_gamma}
\alias{delta_poisson_link_lognormal}
\alias{delta_beta}
\title{Additional families}
\usage{
Beta(link = "logit")

lognormal(link = "log")

gamma_mix(link = "log")

lognormal_mix(link = "log")

nbinom2_mix(link = "log")

nbinom2(link = "log")

nbinom1(link = "log")

truncated_nbinom2(link = "log")

truncated_nbinom1(link = "log")

student(link = "identity", df = 3)

tweedie(link = "log")

censored_poisson(link = "log")

delta_gamma(link1 = "logit", link2 = "log")

delta_gamma_mix(link1 = "logit", link2 = "log")

delta_lognormal(link1 = "logit", link2 = "log")

delta_lognormal_mix(link1 = "logit", link2 = "log")

delta_truncated_nbinom2(link1 = "logit", link2 = "log")

delta_truncated_nbinom1(link1 = "logit", link2 = "log")

delta_poisson_link_gamma(link1 = "log", link2 = "log")

delta_poisson_link_lognormal(link1 = "log", link2 = "log")

delta_beta(link1 = "logit", link2 = "logit")
}
\arguments{
\item{link}{Link.}

\item{df}{Student-t degrees of freedom fixed value parameter.}

\item{link1}{Link for first part of delta/hurdle model.}

\item{link2}{Link for second part of delta/hurdle model.}
}
\value{
A list with elements common to standard R family objects including \code{family},
\code{link}, \code{linkfun}, and \code{linkinv}.
}
\description{
Additional families compatible with \code{\link[=sdmTMB]{sdmTMB()}}.
}
\details{
The families ending in \verb{_mix()} are 2-component mixtures where each
distribution has its own mean but a shared scale parameter.
(Thorson et al. 2011). See the model-description vignette for details.
The parameter \code{plogis(log_p_mix)} is the probability of the extreme (larger)
mean and \code{exp(log_ratio_mix) + 1} is the ratio of the larger extreme
mean to the "regular" mean. You can see these parameters in
\code{model$sd_report}.

The \code{nbinom2} negative binomial parameterization is the NB2 where the
variance grows quadratically with the mean (Hilbe 2011).

The \code{nbinom1} negative binomial parameterization lets the variance grow
linearly with the mean (Hilbe 2011).

For \code{student()}, the degrees of freedom parameter is currently not estimated and is fixed at \code{df}.

\code{delta_poisson_link_gamma()} is the Poisson-link (complementary
log-log) delta model (Thorson 2018).

\code{delta_poisson_link_lognormal()} is the Poisson-link (complementary
log-log) delta model (Thorson 2018).
}
\examples{
Beta(link = "logit")
lognormal(link = "log")
gamma_mix(link = "log")
lognormal_mix(link = "log")
nbinom2_mix(link = "log")
nbinom2(link = "log")
nbinom1(link = "log")
truncated_nbinom2(link = "log")
truncated_nbinom1(link = "log")
student(link = "identity")
tweedie(link = "log")
censored_poisson(link = "log")
delta_gamma()
delta_gamma_mix()
delta_lognormal()
delta_lognormal_mix()
delta_truncated_nbinom2()
delta_truncated_nbinom1()
delta_poisson_link_gamma()
delta_poisson_link_lognormal()
delta_beta()
}
\references{
\emph{Families ending in \verb{_mix()}}:

Thorson, J.T., Stewart, I.J., and Punt, A.E. 2011. Accounting for fish shoals
in single- and multi-species survey data using mixture distribution models.
Can. J. Fish. Aquat. Sci. 68(9): 1681–1693. \doi{10.1139/f2011-086}.

\emph{Negative binomial families}:

Hilbe, J. M. 2011. Negative binomial regression. Cambridge University Press.

\emph{Poisson-link families}:

Thorson, J.T. 2018. Three problems with the conventional delta-model for
biomass sampling data, and a computationally efficient alternative. Canadian
Journal of Fisheries and Aquatic Sciences, 75(9), 1369-1382.
\doi{10.1139/cjfas-2017-0266}
}
