% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_gold_standard.R
\name{add_variable}
\alias{add_variable}
\title{Add a synthetic but realistic variable to a dataset following some rules.}
\usage{
add_variable(
  dataset,
  type,
  country = "uk",
  start_date = "1900-01-01",
  end_date = "2020-01-01",
  age_dependency = FALSE,
  gender_dependency = FALSE,
  race_dependency = FALSE
)
}
\arguments{
\item{dataset}{A data frame of the dataset.}

\item{type}{A string of the type of variable we want to add: 'nhsid', 'dob',
'address', 'firstname' or 'lastname'.}

\item{country}{A string variable with a default of 'uk'. It can be either
'uk' or 'us'.}

\item{start_date}{A Date variable with a default of '1900-01-01'.}

\item{end_date}{A Date variable with a default of '2020-01-01'.}

\item{age_dependency}{A logical variable with a default of FALSE}

\item{gender_dependency}{A logical variable with a default of FALSE}

\item{race_dependency}{A logical variable with a default of FALSE.}
}
\value{
A data frame of the \code{dataset} with a new generated variable.
}
\description{
\code{add_variable} adds a column of new variable to a dataset. This new
    variable generated by some realistic rules. Several type of variables
    are included:
    \enumerate{
    \item {nhsid}: each row is assigned with an identifical 10-digit
    id that is randomly generated following the Modulus 11 Algorithm;
    \item {dob}: if the \code{age_dependency} is TRUE and there is a variable called 'age'
    in the \code{dataset}, the dob is generated based on the value of age and
    \code{end_date}. If \code{age_dependency} is FALSE, the dob is randomly
    generated between \code{start_date} and \code{end_date};
    \item address: a random UK address sampled from 30,000 UK addresses, see \code{\link{gen_address}};
    \item firstname: randomly sample a firstname from the selected database:
    \itemize{
    \item \code{country} If is 'uk' and \code{gender_dependency} and \code{age_dependency}
    are both TRUE, the generated firstnames will automatically sample a firstname that based
    on the gender and age of the indviduals within the \code{dataset}. The uk
    firstname database was extracted from ONS containing firstnames and their frequencies
    in England and Wales from 1996 to 2018.
    \item If \code{country} is 'us' and \code{gender_dependency} and \code{race_dependency}
    are both TRUE, the generated firstnames will automatically sample a firstname that based
    on the gender and ethnicity of the indviduals within the \code{dataset}. The us
    firstname database was extracted from \code{\link[randomNames:randomNamesData]{randomNamesData}}.
    Current ethnicity codes are: 1 American Indian or Native Alaskan, 2 Asian or Pacific Islander,
    3 Black (not Hispanic), 4 Hispanic, 5 White (not Hispanic) and 6 Middle-Eastern, Arabic.
    }
    \item lastname: randomly sample a lastname from the selected database:
    \itemize{
    \item If \code{country} is 'uk', the generated lastnames will automatically sample
    a lastname from a extracted lastname database. The lastname database was extracted
    from ONS.
    \item If \code{country} is 'us' and \code{race_dependency} is TRUE, the generated
    lastnames will automatically sample a lastname that based on the indvidual's ethnicity.
    The us lastname database was extracted from \code{\link[randomNames:randomNamesData]{randomNamesData}}.
    }
    }
}
\examples{
tmp1 <- add_variable(adult[1:100,], "nhsid")
tmp2 <- add_variable(adult[1:100,], "dob", end_date = "2015-03-02", age_dependency = TRUE)
tmp3 <- add_variable(adult[1:100,], "address")
tmp4 <- add_variable(adult[1:100,], "firstname", country = "uk", age_dependency = TRUE,
                     gender_dependency = TRUE)
tmp5 <- add_variable(adult[1:100,], "lastname", country = "uk")
tmp6 <- add_variable(adult[1:100,], 'firstname', country = 'us', gender_dependency=TRUE,
                     race_dependency=TRUE)
tmp7 <- add_variable(adult[1:100,], 'lastname', country='us', race_dependency = TRUE)

}
