% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInfo.R
\name{getInfo}
\alias{getInfo}
\title{Retrieve information in \code{sdcProblem} or \code{problemInstance} objects}
\usage{
getInfo(object, type)
}
\arguments{
\item{object}{an object of class \code{sdcProblem} or \code{problemInstance}}

\item{type}{a scalar character specifying the information which should be
returned. If \code{object} inherits class \code{problemInstance}, the
slots are directly accessed, otherwise the values within slot \code{problemInstance}
of the \code{sdcProblem} object are queried. Valid choices are:
\itemize{
\item the object has not yet been protected
\itemize{
\item \code{lb} and \code{ub}: current possible lower and upper bounds
\item \code{LPL}, \code{SPL}, \code{UPL}: current lower, sliding and upper protection levels
\item \code{sdcStatus}:  current sdc-status of cells
\item \code{freq}: cell frequencies
\item \code{strID}: standardized cell ids (chr)
\item \code{numVars}: \code{NULL} or a list with a slot for each tabulated numerical variable;
\item \code{w}: sampling weights or \code{NULL}
}
\item the table has already been protected
\itemize{
\item \code{finalData}: protected table as a \code{data.table}
\item \code{nrNonDuplicatedCells}: number of unique (non-bogus) cells in the table
\item \code{nrPrimSupps}: number of primary sensitive cells that were protected
\item \code{nrSecondSupps}: number of additional secondary suppressions
\item \code{nrPublishableCells}: number of cells (status \verb{"s} or `"z") that may
be published
\item \code{suppMethod}: name of the algorithm used to protect the table
}
}}
}
\value{
manipulated data depending on arguments \code{object} and \code{type}
}
\description{
Function \code{\link[=getInfo]{getInfo()}} is used to extract values from
\code{sdcProblem} or \code{problemInstance} objects
}
\examples{
# define an example problem with two hierarchies
p <- sdc_testproblem(with_supps = FALSE)

# apply primary suppression
p <- primarySuppression(p, type = "freq", maxN = 3)

# `p` is an `sdcProblem` object
print(class(p))

for (slot in c("lb", "ub", "LPL", "SPL", "UPL", "sdcStatus",
  "freq", "strID", "numVars", "w")) {
  message("slot: ", shQuote(slot))
  print(getInfo(p, type = slot))
}

# protect the cell and extract results
p_protected <- protectTable(p, method = "SIMPLEHEURISTIC")
for (slot in c("finalData", "nrNonDuplicatedCells", "nrPrimSupps",
  "nrSecondSupps", "nrPublishableCells", "suppMethod")) {
  message("slot: ", shQuote(slot))
  print(getInfo(p_protected, type = slot))
}
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}
