% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runArgusBatchFile.R
\name{runArgusBatchFile}
\alias{runArgusBatchFile}
\title{runArgusBatchFile}
\usage{
runArgusBatchFile(obj = NULL, batchF, exe = "C:\\\\Tau\\\\TauArgus.exe",
  batchDataDir = NULL, verbose = FALSE)
}
\arguments{
\item{obj}{\code{NULL} or an object of class \code{\link{sdcProblem-class}} that was used to generate the batchfile for argus. If not \code{NULL},
this object is used to create correct variable names. Else, only the output from tau-Argus is read and returned as a \code{data.table}. In this case
it is possible to run tau-Argus on arbitrarily created batch-files.}

\item{batchF}{a filepath to an batch-input file created by e.g. \code{\link{createArgusInput}}.}

\item{exe}{(character) file-path to tau-argus executable}

\item{batchDataDir}{if different from \code{NULL}, this directory is used to look for input-file and writes output files to.
This helps to use relative paths in batch input files.}

\item{verbose}{(logical) if \code{TRUE}, some additional information is printed to the prompt}
}
\value{
a \code{data.table} containing the protected table or an error in case the batch-file was not solved correctly
if the batch-file was created using sdcTable (argument \code{obj}) was specified. In
case an arbitrarily batch-file has been run, \code{NULL} is returned.
}
\description{
allows to run batch-files for tau argus given the path to an executable of argus.
The provided batch input files can either be created using function \code{\link{createArgusInput}} or
can be arbitrarily created. In the latter case, argument \code{obj} should not be specified and not output
is returned, the script is just executed in tau-argus.
}
\note{
in case a custom batch-file is used as input (e.g \code{obj} is \code{NULL}), this
functions does currently not try to read in any tables to the system.
}
