% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/generics_sdcProblem.r, R/methods_class_sdcProblem.r
\docType{methods}
\name{calc.sdcProblem}
\alias{calc.sdcProblem}
\alias{calc.sdcProblem,sdcProblem,character,list-method}
\title{perform calculations on \code{sdcProblem}-objects depending on argument \code{type}}
\usage{
calc.sdcProblem(object, type, input)

\S4method{calc.sdcProblem}{sdcProblem,character,list}(object, type, input)
}
\arguments{
\item{object}{an object of class \code{sdcProblem}}

\item{type}{a character vector of length 1 defining what to calculate|return|modify. Allowed types are:}
\itemize{
\item rule.freq: modify suppression status within \code{object} according to frequency suppression rule
\item rule.nk: modify sdcStatus of \code{object} according to nk-dominance rule
\item rule.p: modify sdcStatus of \code{object} according to p-percent rule
\item rule.pq: modify sdcStatus of \code{object} according to pq-rule
\item heuristicSolution: obtain a heuristic (greedy) solution to the problem defined by \code{object}
\item cutAndBranch: solve a secondary cell suppression problem defined by \code{object} using cut and branch
\item anonWorker: is used to solve the suppression problem depending on information provided with argument \code{input}
\item ghmiter: solve a secondary cell suppression problem defined by \code{object} using hypercube algorithm
\item preprocess: perform a preprocess procedure by trying to identify primary suppressed cells that are already protected due to other primary suppressed cells
\item cellID: find index of cell defined by information provided with argument \code{input}
\item finalize: create an object of class \code{safeObj}
\item ghmiter.diagObj: calculate codes required to identify diagonal cells given a valid cell code - used for ghmiter-algorithm only
\item ghmiter.calcInformation: calculate information for quaders identified by diagonal indices - used for ghmiter-algorithm only
\item ghmiter.suppressQuader: suppress a quader based on indices
\item ghmiter.selectQuader: select a quader for suppression depending on information provided with argument \code{input} - used for ghmiter-algorithm only
\item ghmiter.suppressAdditionalQuader: select and suppress an additional quader (if required) based on information provided with argument \code{input} - used for ghmiter-algorithm only
\item contributingIndices: calculate indices within the current problem that contribute to a given cell
\item reduceProblem: reduce the problem given by \code{object} using a vector of indices
\item genStructuralCuts: calculate cuts that are absolute necessary for a valid solution of the secondary cell suppression problem}

\item{input}{a list depending on argument \code{type}.}
\itemize{
\item a list (typically generated using genParaObj()) specifying parameters for primary cell suppression if argument \code{type} matches 'rule.freq', 'rule.nk' or 'rule.p'
\item a list if argument \code{type} matches 'heuristicSolution' having the following elements:
\itemize{
\item element 'aProb': an object of class \code{linProb} defining the attacker's problem
\item element 'validCuts': an object of class \code{cutList} representing a list of constraints
\item element 'solver': a character vector of length 1 specifying a solver to use
\item element 'verbose': a logical vector of length 1 setting if verbose output is desired }
\item a list (typically generated using genParaObj()) specifying parameters for the secondary cell suppression problem if argument \code{type} matches 'cutAndBranch', 'anonWorker', 'ghmiter', 'preprocess'
\item a list of length 3 if argument \code{type} matches 'cellID' having following elements
\itemize{
\item first element: character vector specifying variable names that need to exist in slot 'dimInfo' of \code{object}
\item second element: character vector specifying codes for each variable that define a specific table cell
\item third element: logical vector of length 1 with TRUE setting verbosity and FALSE to turn verbose output off}
\item a list of length 3 if argument \code{type} matches 'ghmiter.diagObj' having following elements
\itemize{
\item first element: numeric vector of length 1
\item second element:  a list with as many elements as dimensional variables have been specified and each element being a character vector of dimension-variable specific codes
\item third element: logical vector of length 1 defining if diagonal indices with frequency == 0 should be allowed or not}
\item a list of length 4 if argument \code{type} matches 'ghmiter.calcInformation' having following elements
\itemize{
\item first element: a list object typically generated with method \code{calc.sdcProblem} and type=='ghmiter.diagObj'
\item second element: a list with as many elements as dimensional variables have been specified and each element being a character vector of dimension-variable specific codes
\item third element: numeric vector of length 1 specifying a desired protection level
\item fourth element: logical vector of length 1 defining if quader containing empty cells should be allowed or not}
\item a list of length 1 if argument \code{type} matches 'ghmiter.suppressQuader' having following element
\itemize{
\item first element: numeric vector of indices that should be suppressed }
\item a list of length 2 if argument \code{type} matches 'ghmiter.selectQuader' having following elements
\itemize{
\item first element: a list object typically generated with method \code{calc.sdcProblem} and type=='ghmiter.calcInformation'
\item second element: a list (typically generated using genParaObj())}
\item a list of length 4 if argument \code{type} matches 'ghmiter.suppressAdditionalQuader' having following elements
\itemize{
\item first element: a list object typically generated with method \code{calc.sdcProblem} and type=='ghmiter.diagObj'
\item second element: a list object typically generated with method \code{calc.sdcProblem} and type=='ghmiter.calcInformation'
\item third element: a list object typically generated with method \code{calc.sdcProblem} and type=='ghmiter.selectQuader'
\item fourth element: a list (typically generated using genParaObj()) }
\item a list of length 1 if argument \code{type} matches 'contributingIndices' having following element
\itemize{
\item first element: character vector of length 1 being an ID for which contributing indices should be calculated }
\item a list of length 1 if argument \code{type} matches 'reduceProblem' having following element
\itemize{
\item first element: numeric vector defining indices of cells that should be kept in the reduced problem }
\item an empty list if argument \code{type} matches 'genStructuralCuts'}
}
\value{
information from objects of class \code{sdcProblem} depending on argument \code{type}
\itemize{
\item an object of class \code{sdcProblem} if argument \code{type} matches 'rule.freq', 'rule.nk', 'rule.p', 'cutAndBranch', 'anonWorker', 'ghmiter', 'ghmiter.supressQuader', 'ghmiter.suppressAdditionalQuader' or 'reduceProblem'
\item a numeric vector with elements being 0 or 1 if argument \code{type} matches 'heuristicSolution'
\item a list if argument \code{type} matches 'preprocess' having following elements:
\itemize{
\item element 'sdcProblem': an object of class \code{sdcProblem}
\item element 'aProb': an object of class \code{linProb}
\item element 'validCuts': an object of class \code{cutList}	}
\item a numeric vector of length 1 specifying the index of the cell of interest if argument \code{type} matches 'cellID'
\item an object of class \code{safeObj} if argument \code{type} matches 'finalize'
\item a list if argument \code{type} matches 'ghmiter.diagObj' having following elements:
\itemize{
\item element 'cellToProtect': character vector of length 1 defining the ID of the cell to protect
\item element 'indToProtect': numeric vector of length 1 defining the index of the cell to protect
\item element 'diagIndices': numeric vector defining indices of possible cells defining cubes }
\item a list containing information about each quader that could possibly be suppressed if argument \code{type} matches 'ghmiter.calcInformation'
\item a list containing information about a single quader that should be suppressed if argument \code{type} matches 'ghmiter.selectQuader'
\item a numeric vector with indices that contribute to the desired table cell if argument \code{type} matches 'contributingIndices'
\item an object of class \code{cutList} if argument \code{type} matches 'genStructuralCuts'
}
}
\description{
perform calculations on \code{sdcProblem}-objects depending on argument \code{type}
}
\note{
internal function
}
\author{
Bernhard Meindl \email{bernhard.meindl@statistik.gv.at}
}

