% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUIfunctions.R
\name{readMicrodata}
\alias{readMicrodata}
\title{readMicrodata}
\usage{
readMicrodata(
  path,
  type,
  convertCharToFac = TRUE,
  drop_all_missings = TRUE,
  ...
)
}
\arguments{
\item{path}{a file path}

\item{type}{which format does the file have. currently allowed values are
\itemize{
\item \code{sas}
\item \code{spss}
\item \code{stata}
\item \code{R}
\item \code{rdf}
\item \code{csv}
}}

\item{convertCharToFac}{(logical) if TRUE, all character vectors are automatically
converted to factors}

\item{drop_all_missings}{(logical) if TRUE, all variables that contain NA-values only
will be dropped}

\item{...}{additional parameters. Currently used only if \code{type='csv'} to pass
arguments to \code{read.table()}.}
}
\value{
a data.frame or an object of class 'simple.error'. If a stata file was read in, the resulting \code{data.frame}
has an additional attribute \code{lab} in which variable and value labels are stored.
}
\description{
reads data from various formats into R. Used in \code{\link{sdcApp}}.
}
\note{
if \code{type} is either \code{'sas'}, \code{'spss'} or \code{'stata'}, values read in as \code{NaN}
will be converted to \code{NA}.
}
\author{
Bernhard Meindl
}
