% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFunctions.R
\name{plot.sdcMicroObj}
\alias{plot.sdcMicroObj}
\title{Plotfunctions for objects of class \code{\link{sdcMicroObj-class}}}
\usage{
\method{plot}{sdcMicroObj}(x, type = "ls", ...)
}
\arguments{
\item{x}{An object of class \code{\link{sdcMicroObj-class}}}

\item{type}{specified what kind of plot will be generated
\itemize{
\item 'ls': plot of local suppressions in key variables
}}

\item{...}{currently ignored}
}
\description{
Descriptive plot function for \code{\link{sdcMicroObj-class}}-objects. Currently
only visualization of local supression is implemented.
}
\examples{

data(testdata)
sdc <- createSdcObj(testdata,
  keyVars=c('urbrur','roof','walls','relat','sex'),
  pramVars=c('water','electcon'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- kAnon(sdc, k=5)
plot(sdc, type="ls")

}
\author{
Bernhard Meindl
}
\keyword{classes}
