% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_to_tree.R
\name{hier_to_tree}
\alias{hier_to_tree}
\title{Convert a nested hierarchy into the default format}
\usage{
hier_to_tree(inp)
}
\arguments{
\item{inp}{a nested tree object created using \code{\link[=hier_create]{hier_create()}}
or an object converted with \code{\link[=hier_convert]{hier_convert()}}}
}
\value{
a nested hierarchy with default format
}
\description{
This function returns a tree in default format (as for
example created using \code{\link[=hier_create]{hier_create()}}) for objects created using
\code{\link[=hier_convert]{hier_convert()}}.
}
\examples{
h <- hier_create(root = "Total",  nodes = LETTERS[1:3])
h <- hier_add(h, root = "A", nodes = c("a1", "a5"))
sdc <- hier_convert(h, as = "sdc")
hier_display(h)
hier_display(hier_to_tree(h))
hier_display(hier_to_tree(sdc))
}
