% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_delete.R
\name{hier_delete}
\alias{hier_delete}
\title{Delete nodes from an existing hierarchy}
\usage{
hier_delete(tree, nodes)
}
\arguments{
\item{tree}{a (nested) hierarchy created using \code{\link[=hier_create]{hier_create()}}
or modified using \code{\link[=hier_add]{hier_add()}}, \code{\link[=hier_delete]{hier_delete()}} or \code{\link[=hier_rename]{hier_rename()}}.}

\item{nodes}{character vector of nodes that should be deleted}
}
\description{
This function allows to delete nodes (levels)
from an existing nested hierarchy.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))
h <- hier_add(h, root = "B", nodes = c("b1", "b2"))
h <- hier_add(h, root = "b1", nodes = "b1a")
hier_display(h)

h <- hier_delete(h, nodes = c("a1", "b1a"))
hier_display(h)
}
