% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scs.R
\name{scs_control}
\alias{scs_control}
\title{SCS Control Arguments}
\usage{
scs_control(max_iters = 5000L, normalize = TRUE, verbose = FALSE,
  cg_rate = 2, scale = 1, rho_x = 0.001, alpha = 1.5,
  eps = 1e-05, acceleration_lookback = 20L)
}
\arguments{
\item{max_iters}{an integer giving the maximum number of iterations (default is \code{5000L}).}

\item{normalize}{a logical giving if heuristic data rescaling should be used (default is \code{TRUE}).}

\item{verbose}{a logical giving if the progress should be printed (default is \code{FALSE}).}

\item{cg_rate}{a double giving the rate at which the CG tolerance for the indirect method is tightened (higher is tighter, default is \code{2.0}).}

\item{scale}{a double giving the factor (default is \code{1.0}) by which the data is rescaled (only used if normalize is \code{TRUE}).}

\item{rho_x}{a double giving the momentum of x term (default os \code{1e-3}).}

\item{alpha}{a double giving the over-relaxation parameter, allowed values are in (0, 2) (default if \code{1.5}).}

\item{eps}{a double giving the convergence tolerance (default is \code{1e-5}).}

\item{acceleration_lookback}{an integer indicating the number of iterations to look back for Anderson acceleration}
}
\value{
a list containing the control parameters.
}
\description{
Details to the \emph{control} parameters.
}
