% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grimmer-map-seq.R
\name{grimmer_map_seq}
\alias{grimmer_map_seq}
\title{GRIMMER-testing with dispersed inputs}
\usage{
grimmer_map_seq(
  data,
  x = NULL,
  sd = NULL,
  n = NULL,
  var = Inf,
  dispersion = 1:5,
  out_min = "auto",
  out_max = NULL,
  include_reported = FALSE,
  include_consistent = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame that \code{grimmer_map()} could take.}

\item{x, sd, n}{Optionally, specify these arguments as column names in \code{data}.}

\item{var}{String. Names of the columns that will be dispersed. Default is
\code{c("x", "sd", "n")}.}

\item{dispersion}{Numeric. Sequence with steps up and down from the \code{var}
inputs. It will be adjusted to these values' decimal levels. For example,
with a reported \code{8.34}, the step size is \code{0.01}. Default is \code{1:5}, for five
steps up and down.}

\item{out_min, out_max}{If specified, output will be restricted so that it's
not below \code{out_min} or above \code{out_max}. Defaults are \code{"auto"} for
\code{out_min}, i.e., a minimum of one decimal unit above zero; and \code{NULL} for
\code{out_max}, i.e., no maximum.}

\item{include_reported}{Boolean. Should the reported values themselves be
included in the sequences originating from them? Default is \code{FALSE} because
this might be redundant and bias the results.}

\item{include_consistent}{Boolean. Should the function also process
consistent cases (from among those reported), not just inconsistent ones?
Default is \code{FALSE} because the focus should be on clarifying
inconsistencies.}

\item{...}{Arguments passed down to \code{grimmer_map()}. \emph{(NOTE: Don't use the
\code{items} argument. It currently contains a bug that will be fixed in the
future.)}}
}
\value{
A tibble (data frame) with detailed test results.
}
\description{
\code{grimmer_map_seq()} performs GRIMMER-testing with values
surrounding the input values. This provides an easy and powerful way to
assess whether small errors in computing or reporting may be responsible
for GRIMMER-inconsistencies in published statistics.

Call \code{audit_seq()} on the results for summary statistics.
}
\section{Summaries with \code{audit_seq()}}{
 You can call \code{audit_seq()} following
\code{grimmer_map_seq()}. It will return a data frame with these columns:
\itemize{
\item \code{x}, \code{sd}, and \code{n} are the original inputs,
tested for \code{consistency} here.
\item \code{hits_total} is the total number of GRIMMER-consistent value sets
found within the specified \code{dispersion} range.
\item \code{hits_x} is the number of GRIMMER-consistent value sets
found by varying \code{x}.
\item Accordingly with \code{sd} and \code{hits_sd} as well as \code{n} and \code{hits_n}.
\item (Note that any consistent reported cases will be counted by the
\verb{hits_*} columns if both \code{include_reported} and \code{include_consistent}
are set to \code{TRUE}.)
\item \code{diff_x} reports the absolute difference between \code{x} and the next
consistent dispersed value (in dispersion steps, not the actual numeric
difference). \code{diff_x_up} and \code{diff_x_down} report the difference to the
next higher or lower consistent value, respectively.
\item \code{diff_sd}, \code{diff_sd_up}, and \code{diff_sd_down} do the same for \code{sd}.
\item Likewise with \code{diff_n}, \code{diff_n_up}, and \code{diff_n_down}.
}

Call \code{audit()} following \code{audit_seq()} to summarize results even further.
It's mostly self-explaining, but \code{na_count} and \code{na_rate} are the number
and rate of times that a difference could not be computed because of a lack
of corresponding hits within the \code{dispersion} range.
}

\examples{
# `grimmer_map_seq()` can take any input
# that `grimmer_map()` can take:
pigs5

# All the results:
out <- grimmer_map_seq(pigs5, include_consistent = TRUE)
out

# Case-wise summaries with `audit_seq()`
# can be more important than the raw results:
out \%>\%
  audit_seq()
}
