% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimal-places.R
\name{decimal_places}
\alias{decimal_places}
\alias{decimal_places_scalar}
\title{Count decimal places}
\usage{
decimal_places(x, sep = "\\\\.")

decimal_places_scalar(x, sep = "\\\\.")
}
\arguments{
\item{x}{Numeric (or string that can be coerced to numeric). Object with
decimal places to count.}

\item{sep}{Substring that separates the mantissa from the integer part.
Default is \code{"\\\\."}, which renders a decimal point.}
}
\value{
Integer. Number of decimal places in \code{x}.
}
\description{
\code{decimal_places()} counts the decimal places in a numeric
vector, or in a string vector that can be coerced to numeric.

\code{decimal_places_scalar()} is much faster but only takes a single input. It
is useful as a helper within other single-case functions.
}
\details{
Decimal places in numeric values can't be counted accurately if the
number has 15 or more characters in total, including the integer part and
the decimal point. A possible solutions is to enter the number as a string
to count all digits. (Converting to string is not sufficient -- those
numbers need to be \emph{entered} in quotes.)

The functions ignore any whitespace at the end of a string, so they won't
mistake spaces for decimal places.
}
\section{Trailing zeros}{
 If trailing zeros matter, don't convert numeric
values to strings: In numeric values, any trailing zeros have already been
dropped, and any information about them was lost (e.g., \code{3.70} returns
\code{3.7}). Enter those values as strings instead, such as \code{"3.70"} instead of
\code{3.70}. However, you can restore lost trailing zeros with \code{restore_zeros()}
if the original number of decimal places is known.

If you need to enter many such values as strings, consider using
\code{tibble::tribble()} and drawing quotation marks around all values in a
\code{tribble()} column at once via RStudio's multiple cursors.
}

\examples{
# `decimal_places()` works on both numeric values
# and strings...
decimal_places(x = 2.851)
decimal_places(x = "2.851")

# ... but trailing zeros are only counted within
# strings:
decimal_places(x = c(7.3900, "7.3900"))

# This doesn't apply to non-trailing zeros; these
# behave just like any other digit would:
decimal_places(x = c(4.08, "4.08"))

# Whitespace at the end of a string is not counted:
decimal_places(x = "6.0     ")

# `decimal_places_scalar()` is much faster,
# but only works with a single number or string:
decimal_places_scalar(x = 8.13)
decimal_places_scalar(x = "5.024")


}
\seealso{
\code{decimal_places_df()}, which applies \code{decimal_places()} to all
numeric-like columns in a data frame.
}
