% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore-zeros.R
\name{restore_zeros}
\alias{restore_zeros}
\title{Restore trailing zeros}
\usage{
restore_zeros(x, width = NULL, sep_in = "\\\\.", sep_out = sep_in, sep = NULL)
}
\arguments{
\item{x}{Numeric (or string coercible to numeric). Vector of numbers that
might have lost trailing zeros.}

\item{width}{Integer. Number of decimal places the mantissas should have,
including the restored zeros. Default is \code{NULL}, in which case the number
of characters in the longest mantissa will be used instead.}

\item{sep_in}{Substring that separates the input's mantissa from its integer
part. Default is \code{"\\\\."}, which renders a decimal point.}

\item{sep_out}{Substring that will be returned in the output to separate the
mantissa from the integer part. By default, \code{sep_out} is the same as
\code{sep_in}.}

\item{sep}{[\link{Deprecated}] Use \code{sep_in}, not \code{sep}. If \code{sep} is specified
nonetheless, \code{sep_in} takes on \code{sep}'s value.}
}
\value{
A string vector. At least some of the strings will have newly
restored zeros, unless (1) all input values had the same number of decimal
places, and (2) \code{width} was not specified as a number greater than that
single number of decimal places.
}
\description{
\code{restore_zeros()} takes a vector with values that might have
lost trailing zeros, most likely from being registered as numeric. It turns
each value into a string and adds trailing zeros until the mantissa hits
some limit.

The default for that limit is the number of digits in the longest mantissa
of the vector's values. The length of the integer part plays no role.

Don't rely on the default limit without checking: The original width could
have been larger because the longest extant mantissa might itself have lost
trailing zeros.
}
\details{
This function exploits the fact that groups of summary values such
as means or percentages are often reported to the same number of decimal
places. If such a number is known but values were not entered as strings,
trailing zeros will be lost. In this case, \code{restore_zeros()} will be
helpful to prepare data for consistency testing functions such as
\code{grim_map()} or \code{debit_map()}. Otherwise, it should probably not be used.
}
\section{Displaying decimal places}{
 You might not see all decimal places of
numeric values in a vector, and consequently wonder if \code{restore_zeros()},
when applied to the vector, adds too many zeros. That is because displayed
numbers, unlike stored numbers, are often rounded.

For a vector \code{x}, you can count the characters of the longest mantissa from
among its values like this:

\code{x \%>\% decimal_places() \%>\% max()}
}

\examples{
# By default, the target width is that of
# the longest mantissa:
vec <- c(212, 75.38, 4.9625)
vec \%>\% restore_zeros()

# Alternatively, supply a number via `width`:
vec \%>\% restore_zeros(width = 6)
}
\seealso{
Wrapped functions: \code{sprintf()} and \code{decimal_places()}.
}
