% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate-count.R
\name{duplicate_count}
\alias{duplicate_count}
\title{Count duplicate values}
\usage{
duplicate_count(x, numeric_only = TRUE)
}
\arguments{
\item{x}{Vector or data frame.}

\item{numeric_only}{Boolean. If \code{TRUE} (the default), and if \code{x} is a data
frame, the function includes only numeric columns and string columns
coercible to numeric. \emph{Note}: Be careful when setting it to \code{FALSE}. This
can lead to all kinds of coercion issues.}
}
\value{
A tibble with two columns —
\itemize{
\item \code{value} includes all the values from \code{x}.
\item \code{count} is the frequency of each value in \code{x}, in descending order.
The tibble has the \code{scr_dup_count} class, which is recognized by the
\code{audit()} generic.
}
}
\description{
\code{duplicate_count()} returns a frequency table. When searching a
data frame, it includes values from all columns for each frequency count.

This function is a blunt tool designed for initial data checking. Don't put
too much weight on its results.

For summary statistics, call \code{audit()} on the results.
}
\details{
\code{duplicate_count()} is a thin wrapper around \code{janitor::get_dupes()}.
Use \code{get_dupes()} to search for duplicate rows.

The function is not too informative if the values have few characters.
}
\section{Summaries with \code{audit()}}{
 There is an S3 method for the \code{audit()}
generic, so you can call \code{audit()} following \code{duplicate_count()} to get
summary statistics. These are mostly self-explaining, but \code{count_max} and
\code{count_min} only directly apply to \code{count} and display their respective
\code{value} numbers, not the minimal and maximal \code{value} numbers.
}

\examples{
# Count duplicate values...
BJsales \%>\%
  duplicate_count()

# ...and compute summaries:
BJsales \%>\%
  duplicate_count() \%>\%
  audit()
}
\seealso{
\code{duplicate_detect()} checks if values have duplicates.
}
