% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dataline.R
\name{set_dataline}
\alias{set_dataline}
\alias{add_dataline}
\title{Set data lines of an scplot}
\usage{
set_dataline(object, variable = NULL, line, point, type = "continuous", ...)

add_dataline(...)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{variable}{String. The name of a new variable for adding a new line. If
left empty, the aesthetics of the default data line are changed.}

\item{line}{List with line parameters (\verb{"colour", "linewidth", "linetype", "lineend", "arrow"}). See \code{\link[=element_line]{element_line()}}.}

\item{point}{A list with point parameters (\verb{"colour", "size", "shape"}). See
\code{\link[=element_point]{element_point()}}.}

\item{type}{Either "continuous" or "discrete"}

\item{...}{As a shortcut, arguments passed hear are bundled as \code{line}
arguments (see \code{\link[=element_line]{element_line()}}).}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with a changed \code{datalines}
element.
}
\description{
Either set aesthetics of the default data line or add another data line.
}
\examples{
p1 <- scplot(exampleAB_add) \%>\%
  set_dataline("depression", color = "darkblue")
}
\seealso{
\code{\link[=element_line]{element_line()}}, \code{\link[=element_point]{element_point()}}
}
