% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scplotMulti.R
\name{scplotMulti}
\alias{scplotMulti}
\title{Plot Synthetic Control Point Estimates and Prediction Interval With Multiple Treated units and Staggered Adoption}
\usage{
scplotMulti(
  result,
  type = "series",
  e.out = TRUE,
  joint = FALSE,
  col.treated = "black",
  col.synth = "mediumblue",
  scales = "fixed",
  point.size = 1.5,
  ncols = 3,
  save.data = NULL,
  verbose = TRUE
)
}
\arguments{
\item{result}{a class 'scest' object, obtained by calling \code{\link{scest}}, or a class
'scpi' object, obtained by calling \code{\link{scpi}}. The data object given as input to this command has to be
processed with \code{\link{scdataMulti}}.}

\item{type}{a character that specifies the type of plot to be produced. If set to 'treatment' then treatment effects are plotted.
If set to 'series' (default), the actual and synthetic time series are reported.}

\item{e.out}{a logical specifying whether out-of-sample uncertainty should be included in the plot(s).}

\item{joint}{a logical specifying whether simultaneous prediction intervals should be included in the plot(s). It requires \code{e.out = TRUE}.}

\item{col.treated}{a string specifying the color for the treated unit series. Find the full list at \url{http://sape.inf.usi.ch/quick-reference/ggplot2/colour}.}

\item{col.synth}{a string specifying the color for the synthetic unit series. Find the full list at \url{http://sape.inf.usi.ch/quick-reference/ggplot2/colour}.}

\item{scales}{should axes scales be fixed ("fixed", the default), free ("free"), or free in one dimension ("free_x", "free_y")?}

\item{point.size}{a scalar controlling the size of points in the scatter plot. Default is 1.5.}

\item{ncols}{an integer controlling the number of columns in the plot.}

\item{save.data}{a character specifying the name and the path of the saved dataframe containing the processed data used to produce the plot.}

\item{verbose}{if \code{TRUE} prints additional information in the console.}
}
\value{
\item{plots}{a list containing standard ggplot object(s) that can be used for further customization.}
}
\description{
The command produces a wide range of plots of Synthetic Control estimates and corresponding prediction intervals. The command allows form multiple treated units and staggered adoption.
Prediction intervals can take into account either in-sample uncertainty only or in-sample and
out-of-sample uncertainty using the techniques developed in \href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, Feng, and Titiunik (2021)}. \code{\link{scpi}}.
The input object should come from the command \code{\link{scest}} or from the command \code{\link{scpi}}.

Companion \href{https://www.stata.com/}{Stata} and \href{https://www.python.org/}{Python} packages are described in \href{https://arxiv.org/abs/2202.05984}{Cattaneo, Feng, Palomba, and Titiunik (2022)}.

Companion commands are:  \link{scdata} and \link{scdataMulti} for data preparation in the single and multiple treated unit(s) cases, respectively,
\link{scest} for point estimation, \link{scpi} for inference procedures, and \link{scplotMulti} for plots with multiple treated units.

Related Stata, R, and Python packages useful for inference in SC designs are described in the following website:

\href{ https://nppackages.github.io/scpi/}{ https://nppackages.github.io/scpi/}

For an introduction to synthetic control methods, see \href{https://www.aeaweb.org/articles?id=10.1257/jel.20191450}{Abadie (2021)} and references therein.
}
\examples{

datager <- scpi_germany

datager$tr_id <- 0
datager$tr_id[(datager$country == "West Germany" & datager$year > 1990)] <- 1
datager$tr_id[(datager$country == "Italy" & datager$year > 1992)] <- 0

outcome.var <- "gdp"
id.var <- "country"
treatment.var <- "tr_id"
time.var <- "year"
df.unit <- scdataMulti(datager, id.var = id.var, outcome.var = outcome.var,
                       treatment.var = treatment.var,
                       time.var = time.var, features = list(c("gdp", "trade")),
               		    cointegrated.data = TRUE, constant = TRUE)

res.unit <- scpi(df.unit, sims = 10, cores = 1)
scplotMulti(res.unit, joint = TRUE)

}
\references{
\itemize{
\item{\href{https://www.aeaweb.org/articles?id=10.1257/jel.20191450}{Abadie, A. (2021)}. Using synthetic controls: Feasibility, data requirements, and methodological aspects.
\emph{Journal of Economic Literature}, 59(2), 391-425.}
\item{\href{https://cattaneo.princeton.edu/papers/Cattaneo-Feng-Titiunik_2021_JASA.pdf}{Cattaneo, M. D., Feng, Y., and Titiunik, R.
(2021)}. Prediction intervals for synthetic control methods. \emph{Journal of the American Statistical Association}, 116(536), 1865-1880.}
\item{\href{https://arxiv.org/abs/2202.05984}{Cattaneo, M. D., Feng, Y., Palomba F., and Titiunik, R. (2022)},
scpi: Uncertainty Quantification for Synthetic Control Methods, \emph{arXiv}:2202.05984.}
\item{\href{https://arxiv.org/abs/2210.05026}{Cattaneo, M. D., Feng, Y., Palomba F., and Titiunik, R. (2022).}
Uncertainty Quantification in Synthetic Controls with Staggered Treatment Adoption, \emph{arXiv}:2210.05026.}
}
}
\seealso{
\code{\link{scdata}}, \code{\link{scdataMulti}}, \code{\link{scest}}, \code{\link{scpi}}, \code{\link{scplotMulti}}
}
\author{
Matias Cattaneo, Princeton University. \email{cattaneo@princeton.edu}.

Yingjie Feng, Tsinghua University. \email{fengyj@sem.tsinghua.edu.cn}.

Filippo Palomba, Princeton University (maintainer). \email{fpalomba@princeton.edu}.

Rocio Titiunik, Princeton University. \email{titiunik@princeton.edu}.
}
