% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-point.R
\name{get_metrics.forecast_point}
\alias{get_metrics.forecast_point}
\title{Get default metrics for point forecasts}
\usage{
\method{get_metrics}{forecast_point}(x, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{x}{A forecast object (a validated data.table with predicted and
observed values, see \code{\link[=as_forecast_binary]{as_forecast_binary()}}).}

\item{select}{A character vector of scoring rules to select from the list. If
\code{select} is \code{NULL} (the default), all possible scoring rules are returned.}

\item{exclude}{A character vector of scoring rules to exclude from the list.
If \code{select} is not \code{NULL}, this argument is ignored.}

\item{...}{unused}
}
\description{
For point forecasts, the default scoring rules are:
\itemize{
\item "ae_point" = \link[Metrics:ae]{ae()}
\item "se_point" = \link[Metrics:se]{se()}
\item "ape" = \link[Metrics:ape]{ape()}
}

A note of caution: Every scoring rule for a point forecast
is implicitly minimised by a specific aspect of the predictive distribution
(see Gneiting, 2011).

The mean squared error, for example, is only a meaningful scoring rule if
the forecaster actually reported the mean of their predictive distribution
as a point forecast. If the forecaster reported the median, then the mean
absolute error would be the appropriate scoring rule. If the scoring rule
and the predictive task do not align, the results will be misleading.

Failure to respect this correspondence can lead to grossly misleading
results! Consider the example in the section below.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-binary-point.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for binary and point forecasts
}
\if{latex}{
  \figure{metrics-binary-point.png}
}
}

\examples{
get_metrics(example_point, select = "ape")

library(magrittr)
set.seed(123)
n <- 500
observed <- rnorm(n, 5, 4)^2

predicted_mu <- mean(observed)
predicted_not_mu <- predicted_mu - rnorm(n, 10, 2)

df <- data.frame(
  model = rep(c("perfect", "bad"), each = n),
  predicted = c(rep(predicted_mu, n), predicted_not_mu),
  observed = rep(observed, 2),
  id = rep(1:n, 2)
) \%>\%
  as_forecast_point()
score(df) \%>\%
  summarise_scores()
}
\references{
Making and Evaluating Point Forecasts, Gneiting, Tilmann, 2011,
Journal of the American Statistical Association.
}
\seealso{
Other get_metrics functions: 
\code{\link{get_metrics}()},
\code{\link{get_metrics.forecast_binary}()},
\code{\link{get_metrics.forecast_nominal}()},
\code{\link{get_metrics.forecast_quantile}()},
\code{\link{get_metrics.forecast_sample}()},
\code{\link{get_metrics.scores}()}
}
\concept{get_metrics functions}
\keyword{handle-metrics}
