% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{make_NA}
\alias{make_NA}
\alias{make_na}
\title{Make Rows NA in Data for Plotting}
\usage{
make_NA(data = NULL, what = c("truth", "forecast", "both"), ...)

make_na(data = NULL, what = c("truth", "forecast", "both"), ...)
}
\arguments{
\item{data}{A data.frame or data.table with the predictions and observations.
For scoring using \code{\link[=score]{score()}}, the following columns need to be present:
\itemize{
\item \code{true_value} - the true observed values
\item \code{prediction} - predictions or predictive samples for one
true value. (You only don't need to provide a prediction column if
you want to score quantile forecasts in a wide range format.)}
For scoring integer and continuous forecasts a \code{sample} column is needed:
\itemize{
\item \code{sample} - an index to identify the predictive samples in the
prediction column generated by one model for one true value. Only
necessary for continuous and integer forecasts, not for
binary predictions.}
For scoring predictions in a quantile-format forecast you should provide
a column called \code{quantile}:
\itemize{
\item \code{quantile}: quantile to which the prediction corresponds
}

In addition a \code{model} column is suggested and if not present this will be
flagged and added to the input data with all forecasts assigned as an
"unspecified model").

You can check the format of your data using \code{\link[=check_forecasts]{check_forecasts()}} and there
are examples for each format (\link{example_quantile}, \link{example_continuous},
\link{example_integer}, and \link{example_binary}).}

\item{what}{character vector that determines which values should be turned
into \code{NA}. If \code{what = "truth"}, values in the column 'true_value' will be
turned into \code{NA}. If \code{what = "forecast"}, values in the column 'prediction'
will be turned into \code{NA}. If \code{what = "both"}, values in both column will be
turned into \code{NA}.}

\item{...}{logical statements used to filter the data}
}
\value{
A data.table
}
\description{
Filters the data and turns values into \code{NA} before the data gets passed to
\code{\link[=plot_predictions]{plot_predictions()}}. The reason to do this is to this is that it allows to
'filter' prediction and truth data separately. Any value that is NA will then
be removed in the subsequent call to \code{\link[=plot_predictions]{plot_predictions()}}.
}
\examples{
make_NA (
    example_continuous,
    what = "truth",
    target_end_date >= "2021-07-22",
    target_end_date < "2021-05-01"
  )
}
\keyword{plotting}
