% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_ranges}
\alias{plot_ranges}
\title{Plot Metrics by Range of the Prediction Interval}
\usage{
plot_ranges(scores, y = "interval_score", x = "model", colour = "range")
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}} or \code{\link[=summarise_scores]{summarise_scores()}}. Note that "range" must be included
in the \code{by} argument when running \code{\link[=summarise_scores]{summarise_scores()}}}

\item{y}{The variable from the scores you want to show on the y-Axis.
This could be something like "interval_score" (the default) or "dispersion"}

\item{x}{The variable from the scores you want to show on the x-Axis.
Usually this will be "model"}

\item{colour}{Character vector of length one used to determine a variable
for colouring dots. The Default is "range".}
}
\value{
A ggplot2 object showing a contributions from the three components of
the weighted interval score
}
\description{
Visualise the metrics by range, e.g. if you are interested how different
interval ranges contribute to the overall interval score, or how
sharpness / dispersion changes by range.
}
\examples{
library(ggplot2)
scores <- score(example_quantile)
scores <- summarise_scores(scores, by = c("model", "target_type", "range"))

plot_ranges(scores, x = "model") +
  facet_wrap(~target_type, scales = "free")

# visualise dispersion instead of interval score
plot_ranges(scores, y = "dispersion", x = "model") +
  facet_wrap(~target_type)
}
