% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_quantile_coverage}
\alias{plot_quantile_coverage}
\title{Plot Quantile Coverage}
\usage{
plot_quantile_coverage(scores, colour = "model")
}
\arguments{
\item{scores}{A data.frame of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}} or \code{\link[=summarise_scores]{summarise_scores()}}. Note that "range" must be included
in the \code{by} argument when running \code{\link[=summarise_scores]{summarise_scores()}}}

\item{colour}{According to which variable shall the graphs be coloured?
Default is "model".}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Plot quantile coverage
}
\examples{
scores <- score(example_quantile)
scores <- summarise_scores(scores, by = c("model", "quantile"))
plot_quantile_coverage(scores)
}
