% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_point_forecasts.R
\name{ae_median_sample}
\alias{ae_median_sample}
\title{Absolute Error of the Median (Sample-based Version)}
\usage{
ae_median_sample(true_values, predictions)
}
\arguments{
\item{true_values}{A vector with the true observed values of size n}

\item{predictions}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, predictions can just be a vector of size n.}
}
\value{
vector with the scoring values
}
\description{
Absolute error of the median calculated as

\deqn{%
  \textrm{abs}(\textrm{true\_value} - \textrm{median\_prediction})
}{%
  abs(true_value - median_prediction)
}
}
\examples{
true_values <- rnorm(30, mean = 1:30)
predicted_values <- rnorm(30, mean = 1:30)
ae_median_sample(true_values, predicted_values)
}
\seealso{
\code{\link[=ae_median_quantile]{ae_median_quantile()}}, \code{\link[=abs_error]{abs_error()}}
}
\keyword{metric}
