% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{score_table}
\alias{score_table}
\title{Plot Coloured Score Table}
\usage{
score_table(
  summarised_scores,
  y = NULL,
  select_metrics = NULL,
  facet_formula = NULL,
  ncol = NULL,
  facet_wrap_or_grid = "facet_wrap"
)
}
\arguments{
\item{summarised_scores}{A data.frame of summarised scores as produced by
\code{\link{eval_forecasts}}}

\item{y}{the variable to be shown on the y-axis. If \code{NULL} (default),
all columns that are not scoring metrics will be used. Alternatively,
you can specify a vector with column names, e.g.
\code{y = c("model", "location")}. These column names will be concatenated
to create a unique row identifier (e.g. "model1_location1")}

\item{select_metrics}{A character vector with the metrics to show. If set to
\code{NULL} (default), all metrics present in \code{summarised_scores} will
be shown}

\item{facet_formula}{formula for facetting in ggplot. If this is \code{NULL}
(the default), no facetting will take place}

\item{ncol}{Number of columns for facet wrap. Only relevant if
\code{facet_formula} is given and \code{facet_wrap_or_grid == "facet_wrap"}}

\item{facet_wrap_or_grid}{Use ggplot2's \code{facet_wrap} or
\code{facet_grid}? Anything other than "facet_wrap" will be interpreted as
\code{facet_grid}. This only takes effect if \code{facet_formula} is not
\code{NULL}}
}
\value{
A ggplot2 object with a coloured table of summarised scores
}
\description{
Plots a coloured table of summarised scores obtained using
\code{\link{eval_forecasts}}
}
\examples{
scores <- scoringutils::eval_forecasts(scoringutils::quantile_example_data_wide,
                                       by = c("model", "id", "horizon"),
                                       summarise_by = c("model", "horizon"))
scoringutils::score_table(scores, y = "model", facet_formula = ~ horizon,
                          ncol = 1)

scoringutils::score_table(scores, y = c("model", "horizon"))

# yields the same result in this case
scoringutils::score_table(scores)
}
