% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{iv_filter}
\alias{iv_filter}
\title{Variable reduction based on Information Value filter}
\usage{
iv_filter(base, iv_table, threshold)
}
\arguments{
\item{base}{input dataframe}

\item{iv_table}{dataframe of class iv_table with two columns - Variable_name, iv}

\item{threshold}{threshold IV value below which the variable will be recommended to be dropped}
}
\value{
An object of class "iv_filter" is a list containing the following components:

\item{retain_var_tab}{variables remaining post IV filter as a dataframe}

\item{retain_var_name}{array of column names of variables to be retained}

\item{dropped_var_tab}{variables that can be dropped based on IV filter as a dataframe}

\item{threshold}{threshold IV value used as input parameter}
}
\description{
The function returns a list of variables that can be dropped because of low discriminatory power, based on Information Value. If IV for a variable is less than a user defined threshold, the variable will be recommended to be dropped by this function.
}
\examples{
data <- iris
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
x <- c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")
iv_table_list <- iv_table(base = data,target = "Y",num_var_name = x,cat_var_name = "Species")
ivf_list <- iv_filter(base = data,iv_table = iv_table_list$iv_table,threshold = 0.02)
ivf_list$retain_var_tab
ivf_list$retain_var_name
ivf_list$dropped_var_tab
ivf_list$threshold
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
