% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard}
\alias{scorecard}
\title{Creating a Scorecard}
\usage{
scorecard(bins, model, points0 = 600, odds0 = 1/19, pdo = 50,
  basepoints_eq0 = FALSE, digits = 0)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{model}{A glm model object.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}

\item{basepoints_eq0}{Logical, Defaults to FALSE. If it is TRUE, the basepoints will equally distribute to each variable.}

\item{digits}{The number of digits after the decimal point for points calculation. Default 0.}
}
\value{
A list of scorecard data frames
}
\description{
\code{scorecard} creates a scorecard based on the results from \code{woebin} and \code{glm}.
}
\examples{
\donttest{
# load germancredit data
data("germancredit")

# filter variable via missing rate, iv, identical value rate
dt_sel = var_filter(germancredit, "creditability")

# woe binning ------
bins = woebin(dt_sel, "creditability")
dt_woe = woebin_ply(dt_sel, bins)

# glm ------
m = glm(creditability ~ ., family = binomial(), data = dt_woe)
# summary(m)

# Select a formula-based model by AIC
m_step = step(m, direction="both", trace=FALSE)
m = eval(m_step$call)
# summary(m)

# predicted proability
# dt_pred = predict(m, type='response', dt_woe)

# performace
# ks & roc plot
# perf_eva(dt_woe$creditability, dt_pred)

# scorecard
# Example I # creat a scorecard
card = scorecard(bins, m)
card2 = scorecard2(bins=bins, dt=germancredit, y='creditability',
  x=sub('_woe', '', names(coef(m))[-1]))

# credit score
# Example I # only total score
score1 = scorecard_ply(germancredit, card)

# Example II # credit score for both total and each variable
score2 = scorecard_ply(germancredit, card, only_total_score = FALSE)
}
}
\seealso{
\code{\link{scorecard2}} \code{\link{scorecard_ply}}
}
