% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_keep.R
\name{var_to_keep}
\alias{var_to_keep}
\title{Decide which variable to keep}
\usage{
var_to_keep(
  values,
  n_kept = NULL,
  prop_kept = NULL,
  cutoff = NULL,
  maximize = TRUE
)
}
\arguments{
\item{values}{A numeric vector, with one value per variable to keep or
discard.}

\item{n_kept}{Number of variables to keep.}

\item{prop_kept}{A numeric value between 0 and 1 representing the proportion
of variables to keep. \code{n_kept} and \code{prop_kept} are mutually exclusive.}

\item{cutoff}{Threshold beyond which (below or above) the variables are
discarded.}

\item{maximize}{Whether to minimize (\code{FALSE}) or maximize (\code{TRUE}, the
default) the quantity given by \code{values}.}
}
\value{
A logical vector indicating if variables are kept or discarded.
}
\description{
Decide which variable to keep
}
\examples{
scimo:::var_to_keep(1:5, n_kept = 3, maximize = TRUE)
scimo:::var_to_keep(1:10, cutoff = 8, maximize = FALSE)
}
\author{
Antoine Bichat
}
\keyword{internal}
