% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_kruskal.R
\name{step_select_kruskal}
\alias{step_select_kruskal}
\alias{tidy.step_select_kruskal}
\title{Feature selection step using Kruskal test}
\usage{
step_select_kruskal(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  outcome = NULL,
  n_kept = NULL,
  prop_kept = NULL,
  cutoff = NULL,
  correction = "none",
  res = NULL,
  skip = FALSE,
  id = rand_id("select_kruskal")
)

\method{tidy}{step_select_kruskal}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing
have been estimated.}

\item{outcome}{Name of the variable to perform the test against.}

\item{n_kept}{Number of variables to keep.}

\item{prop_kept}{A numeric value between 0 and 1 representing the proportion
of variables to keep. \code{n_kept} and \code{prop_kept} are mutually exclusive.}

\item{cutoff}{Threshold beyond which (below or above) the variables are
discarded.}

\item{correction}{Multiple testing correction method. One of
\code{p.adjust.methods}. Default to \code{"none"}.}

\item{res}{This parameter is only produced after the recipe has been trained.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_select_kruskal} object.}
}
\value{
An updated version of recipe with the new step added to the
sequence of any existing operations.
}
\description{
Select variables with the lowest (adjusted) p-value of a
Kruskal-Wallis test against an outcome.
}
\examples{
rec <-
  iris \%>\%
  recipe(formula = Species ~ .) \%>\%
  step_select_kruskal(all_numeric_predictors(), outcome = "Species",
                      correction = "fdr", prop_kept = 0.5) \%>\%
  prep()
rec
tidy(rec, 1)
juice(rec)
}
\author{
Antoine Bichat
}
