% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{as.R}
\alias{as.R}
\title{Download SciDB data to R}
\usage{
as.R(x, only_attributes = FALSE, binary = TRUE)
}
\arguments{
\item{x}{a \code{\link{scidb}} object (a SciDB array or expression)}

\item{only_attributes}{optional logical argument, if \code{TRUE} do not download SciDB dimensions (see note)}

\item{binary}{optional logical value, set to \code{FALSE} to download data using text format (useful for some unsupported SciDB types)}
}
\value{
An R \code{\link{data.frame}}
}
\description{
Download SciDB data to R
}
\note{
This convenience function is equivalent to running \code{iquery(db, x, return=TRUE)} for
a SciDB connection object \code{db}.

The \code{only_attributes=TRUE} option only works with binary transfers, and if specified will set \code{binary=TRUE}.
Beware of the \code{only_attributes=TRUE} setting--SciDB may return data in arbitrary order.

SciDB values are always returned as R data frames. SciDB scalar types are converted to
corresponding R types as follows:
 \itemize{
   \item{double   -> }{double}
   \item{int64    -> }{integer64}
   \item{uint64   -> }{double}
   \item{uint32   -> }{double}
   \item{int32    -> }{integer}
   \item{int16    -> }{integer}
   \item{unit16   -> }{integer}
   \item{int8     -> }{integer}
   \item{uint8    -> }{integer}
   \item{bool     -> }{logical}
   \item{string   -> }{character}
   \item{char     -> }{character}
   \item{binary   -> }{raw}
   \item{datetime -> }{Date}
}
}
\examples{
\dontrun{
db <- scidbconnect()
x <- scidb(db, "build(<v:double>[i=1:5], sin(i))")
as.R(x)
## i          v
## 1  0.8414710
## 2  0.9092974
## 3  0.1411200
## 4 -0.7568025
## 5 -0.9589243

as.R(x, only_attributes=TRUE)
##          v
##  0.8414710
##  0.9092974
##  0.1411200
## -0.7568025
## -0.9589243
}
}
\seealso{
\code{\link{as.scidb}}
}

