% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/token_check.R
\name{token_check}
\alias{token_check}
\title{Check Token Status}
\usage{
token_check(api = "qualtrics", secret = TRUE)
}
\arguments{
\item{api}{(character) API the token is for (currently only supports "qualtrics" and "github")}

\item{secret}{(logical) Whether to include the token character string in the success message. FALSE prints the token, TRUE keeps it secret but returns a success message}
}
\value{
No return value, called for side effects
}
\description{
To make some direct-from-API workflows functional (e.g., Qualtrics surveys, etc.). It is necessary to quickly test whether a given R session "knows" the API token. This function returns an error if the specified token type isn't found and prints a message if one is found
}
\examples{
\dontrun{
# Check whether a GitHub token is attached or not
token_check(api = "github", secret = TRUE)
}
\dontrun{
# Check whether a Qualtrics token is attached or not
token_check(api = "qualtrics", secret = TRUE)
}
}
