% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO.R
\name{ExtractGEOMeta}
\alias{ExtractGEOMeta}
\title{Extract Sample Metadata from GEO.}
\usage{
ExtractGEOMeta(acce, platform = NULL, ...)
}
\arguments{
\item{acce}{GEO accession number.}

\item{platform}{Platform information/field. Default: NULL (all platforms).}

\item{...}{Parameters for \code{\link{getGEO}}.}
}
\value{
Dataframe contains all metadata of provided GEO accession number.
}
\description{
Extract Sample Metadata from GEO.
}
\examples{
\donttest{
# users may need to set the size of the connection buffer
# Sys.setenv("VROOM_CONNECTION_SIZE" = 131072 * 60)
# extract metadata of specified platform
GSE200257.meta <- ExtractGEOMeta(acce = "GSE200257", platform = "GPL24676")
}
}
