% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{embeddingColorsPlot}
\alias{embeddingColorsPlot}
\title{Set colors for embedding plot. Used primarily in embeddingPlot().}
\usage{
embeddingColorsPlot(
  plot.df,
  colors,
  groups = NULL,
  geom_point_w = ggplot2::geom_point,
  gradient.range.quantile = 1,
  color.range = "symmetric",
  legend.title = NULL,
  palette = NULL,
  plot.na = TRUE
)
}
\arguments{
\item{plot.df}{data.frame for plotting. In embeddingPlot(), this is a tibble from tibble::rownames_to_column().}

\item{colors}{vector of numbers, which must be shown with point colors, names contain cell names (default=NULL). This argument is ignored if groups are provided.}

\item{groups}{vector of cluster labels, names contain cell names (default=NULL)}

\item{geom_point_w}{function to work with geom_point layer from ggplot2 (default=ggplot2::geom_point)}

\item{gradient.range.quantile}{Winsorization quantile for the numeric colors and gene gradient (default=1)}

\item{color.range}{controls range, in which colors are estimated (default="symmetric"). Pass "all" to estimate range based on all values of "colors", pass "data" to estimate it only based on colors, presented in the embedding. Alternatively you can pass vector of length 2 with (min, max) values.}

\item{legend.title}{legend title (default=NULL)}

\item{palette}{function, which accepts number of colors and return list of colors (i.e. see 'colorRampPalette') (default=NULL)}

\item{plot.na}{boolean/numeric Whether to plot points, for which groups / colors are missed (default=is.null(subgroups), i.e. FALSE). If plot.na passed a numeric value below 0, the NA symbols are plotted below the cells. Otherwise if values >=0, they’re plotted above the cells. Note that this argument is FALSE if 'subgroups' is NULL}
}
\value{
ggplot2 object
}
\description{
Set colors for embedding plot. Used primarily in embeddingPlot().
}
