# ==============================================================================
# scclust for R -- R wrapper for the scclust library
# https://github.com/fsavje/scclust-R
#
# Copyright (C) 2016-2017  Fredrik Savje -- http://fredriksavje.com
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see http://www.gnu.org/licenses/
# ==============================================================================

library(scclust)
context("nng_clustering_types")

source("config.R", local = TRUE)
source("../replica/replica_findseed.R", local = TRUE)
source("../replica/replica_make_nng.R", local = TRUE)
source("../replica/replica_nng.R", local = TRUE)
source("utils_nng.R", local = TRUE)


test_that("`nng_clustering_types` returns correct output", {
  skip_if_not(!compiled_with_stable_nng, "Only run this when scclust is *not* compiled with the -DSCC_STABLE_NNG flag.")
  skip_if_not(!compiled_with_stable_findseed, "Only run this when scclust is *not* compiled with the -DSCC_STABLE_FINDSEED flag.")

  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 3L, "1" = 3L, "2" = 3L, "3" = 3L),
                                 12L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 0L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "inwards_order",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "inwards_order",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "exclusion_order",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "exclusion_order",
                                 "ignore",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "inwards_order",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "inwards_order",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "exclusion_order",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "exclusion_order",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "lexical",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 0L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "inwards_order",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "inwards_order",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "exclusion_order",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "exclusion_order",
                                 "ignore",
                                 type_test_radius,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "lexical",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "inwards_order",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "inwards_order",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 5L,
                                 "exclusion_order",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "exclusion_order",
                                 "ignore",
                                 type_test_radius,
                                 primary_data_points,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "closest_assigned",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "closest_seed",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "estimated_radius_closest_seed",
                                 NULL,
                                 NULL,
                                 "ignore",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "closest_assigned",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "closest_seed",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "estimated_radius_closest_seed",
                                 NULL)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "closest_assigned",
                                 test_radius)
  test_nng_types_against_replica(test_distances1,
                                 types1,
                                 c("0" = 1L, "1" = 2L, "2" = 1L, "3" = 1L),
                                 10L,
                                 "lexical",
                                 "ignore",
                                 NULL,
                                 primary_data_points,
                                 "closest_seed",
                                 test_radius)
})
