% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evt.R
\name{evt.write}
\alias{evt.write}
\title{Write bursts to a .evt file.}
\usage{
evt.write(segments, filename = "", header = NULL)
}
\arguments{
\item{segments}{A segment or list of segments to write to filename}

\item{filename}{The filename}

\item{header}{The header information for the evt file, if available}
}
\description{
Write bursts to a .evt file.
}
\examples{

infile <- system.file("extdata", "example1_tac.evt", package = "scbursts")

# Get Dwells
transitions <- evt.read(infile)
dwells <- evt.to_dwells(transitions)
dwells_c <- risetime.correct_gaussian(Tr=35.0052278, dwells, units="us")

# Get Header
header <- evt.extract_header(infile)

evt.write(dwells_c, header=header, file=file.path(tempdir(), "fixed_example1_tac.evt"))
}
