% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scape.R
\name{scape}
\alias{scape}
\title{Cytokine activity scores for a normalized matrix.}
\usage{
scape(counts.matrix, database = "cytosig", cytokine = "all")
}
\arguments{
\item{counts.matrix}{A \eqn{m x n} normalized counts matrix with \eqn{m} samples and \eqn{n} genes.}

\item{database}{Database used for gene set construction and set scoring.
\itemize{
\item "cytosig" performs scoring for up to 41 cytokines using the CytoSig database.
\item "reactome" performs scoring for up to 30 cytokines using the Reactome database.
}}

\item{cytokine}{Vector of cytokine names to score for activity. The default value
of "all" will score all 41 cytokines supported by CytoSig or 31 supported by Reactome. Please see
function \code{\link[scaper]{supportedCytokines}} to view all the CytoSig or the Reactome
specific scored cytokines.}
}
\value{
A \eqn{m x p} matrix consisting of the cell-level cytokine activity scores for \eqn{p} cytokines.
}
\description{
Computes cell-level estimates of cytokine activity for a normalized scRNA-seq
count matrix using the SCAPE method. SCAPE activity estimates are computed by scoring weighted genes
sets from the CytoSig or Reactome databases using the \code{\link[VAM:vamForCollection]{VAM::vamForCollection()}}
function. Individual gene sets for subsequent scoring can be reconstructed using
the \code{\link[scaper]{genesetCytoSig}} and the \code{\link[scaper]{genesetReactome}} functions
for the CytoSig and the Reactome database, respectively.
}
\examples{
library(Seurat)
library(SeuratObject)
pbmc_small <- NormalizeData(pbmc_small)
counts.matrix <- as.data.frame(t(as.matrix(pbmc_small@assays$RNA@data)))
CytoSig.score.output <- scape(counts.matrix = counts.matrix, 
database = "cytosig")
head(CytoSig.score.output)[,1:3]
CytoSig.score.output.specific <- scape(counts.matrix = counts.matrix, 
database = "cytosig", cytokine = c("IL4", "IL13"))
head(CytoSig.score.output.specific)

}
\seealso{
{\code{\link{genesetCytoSig}}, \code{\link{genesetReactome}}}
}
