% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanstatistics_general.R
\name{score_locations}
\alias{score_locations}
\title{Score each location over zones and duration.}
\usage{
score_locations(x)
}
\arguments{
\item{x}{An object of class \code{scanstatistic}.}
}
\value{
A \code{data.table} with the following columns:
   \describe{
     \item{location}{The locations (as integers).}
     \item{total_score}{For each location, the sum of all window statistics 
                        that the location appears in.}
     \item{n_zones}{The number of spatial zones that the location appears 
                    in.}
     \item{score}{The total score divided by the number of zones and the 
                  maximum duration.}
     \item{relative_score}{The score divided by the maximum score.}
}
}
\description{
For each location, compute the average of the statistic calculated for each
space-time window that the location is included in, i.e. average the 
statistic over both zones and the maximum duration.
}
\examples{
# Simple example
set.seed(1)
table <- scanstatistics:::create_table(list(location = 1:4, duration = 1:4),
                                        keys = c("location", "duration"))
table[, mu := 3 * location]
table[, count := rpois(.N, mu)]
table[location \%in\% c(1, 4) & duration < 3, count := rpois(.N, 2 * mu)]
zones <- scanstatistics:::powerset_zones(4)
result <- scan_poisson(table, zones, 100)
score_locations(result)
}

