% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-ordinal.R
\name{label_ordinal}
\alias{label_ordinal}
\alias{ordinal_english}
\alias{ordinal_french}
\alias{ordinal_spanish}
\alias{ordinal_format}
\alias{ordinal}
\title{Label ordinal numbers (1st, 2nd, 3rd, etc)}
\usage{
label_ordinal(prefix = "", suffix = "", big.mark = " ",
  rules = ordinal_english(), ...)

ordinal_english()

ordinal_french()

ordinal_spanish()

ordinal_format(prefix = "", suffix = "", big.mark = " ",
  rules = ordinal_english(), ...)

ordinal(x, prefix = "", suffix = "", big.mark = " ",
  rules = ordinal_english(), ...)
}
\arguments{
\item{prefix, suffix}{Symbols to display before and after value.}

\item{big.mark}{Character used between every 3 digits to separate thousands.}

\item{rules}{Named list of regular expressions, matched in order.
Name gives suffix, and value specifies which numbers to match.}

\item{...}{Other arguments passed on to \code{\link[base:format]{base::format()}}.}

\item{x}{A numeric vector to format.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
Round values to integers and then display as ordinal values (e.g. 1st, 2nd,
3rd). Built-in rules are provided for English, French, and Spanish.
}
\section{Old interface}{

\code{ordinal()} and \code{format_ordinal()} are retired; please use \code{label_ordinal()}
instead.
}

\examples{
demo_continuous(c(1, 5))
demo_continuous(c(1, 5), labels = label_ordinal())
demo_continuous(c(1, 5), labels = label_ordinal(rules = ordinal_french()))

# The rules are just a set of regular expressions that are applied in turn
ordinal_french()
ordinal_english()

# Note that ordinal rounds values, so you may need to adjust the breaks too
demo_continuous(c(1, 10))
demo_continuous(c(1, 10), labels = label_ordinal())
demo_continuous(c(1, 10),
  labels = label_ordinal(),
  breaks = breaks_width(2)
)
}
\seealso{
Other labels for continuous scales: \code{\link{label_bytes}},
  \code{\link{label_dollar}},
  \code{\link{label_number_auto}},
  \code{\link{label_number_si}}, \code{\link{label_parse}},
  \code{\link{label_percent}}, \code{\link{label_pvalue}},
  \code{\link{label_scientific}}
}
\concept{labels for continuous scales}
